/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class SdCardDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("SdCardPath", "Hardcoded reference to `/sdcard`", "Your code should not reference the `/sdcard` path directly; instead use `Environment.getExternalStorageDirectory().getPath()`.\n\nSimilarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. Instead, use `Context.getFilesDir().getPath()`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/data/data-storage.html#filesExternal");

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(ULiteralExpression.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new StringChecker(context);
    }

    private static class StringChecker
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private StringChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClass(@NotNull UClass node) {
            return super.visitClass(node);
        }

        public boolean visitLiteralExpression(ULiteralExpression node) {
            String s = UastLiteralUtils.getValueIfStringLiteral((UElement)node);
            if (s != null && !s.isEmpty()) {
                char c = s.charAt(0);
                if (c != '/' && c != 'f') {
                    return false;
                }
                if (s.startsWith("/sdcard") || s.startsWith("/mnt/sdcard/") || s.startsWith("/system/media/sdcard") || s.startsWith("file://sdcard/") || s.startsWith("file:///sdcard/")) {
                    String message = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                    Location location = this.mContext.getUastLocation((UElement)node);
                    this.mContext.report(ISSUE, (UElement)node, location, message);
                } else if (s.startsWith("/data/data/") || s.startsWith("/data/user/")) {
                    String message = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                    Location location = this.mContext.getUastLocation((UElement)node);
                    this.mContext.report(ISSUE, (UElement)node, location, message);
                }
            }
            return super.visitLiteralExpression(node);
        }
    }
}

