/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.LintUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;

public class PluralsDatabase {
    private static final EnumSet<Quantity> NONE = EnumSet.noneOf(Quantity.class);
    private static final PluralsDatabase sInstance = new PluralsDatabase();
    private final Map<String, EnumSet<Quantity>> mPlurals = Maps.newHashMap();
    static final int FLAG_ZERO = 1;
    static final int FLAG_ONE = 2;
    static final int FLAG_TWO = 4;
    static final int FLAG_FEW = 8;
    static final int FLAG_MANY = 16;
    static final int FLAG_MULTIPLE_ZERO = 32;
    static final int FLAG_MULTIPLE_ONE = 64;
    static final int FLAG_MULTIPLE_TWO = 128;
    private static final String[] LANGUAGE_CODES = new String[]{"af", "ak", "am", "ar", "as", "az", "be", "bg", "bh", "bm", "bn", "bo", "br", "bs", "ca", "ce", "cs", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fo", "fr", "fy", "ga", "gd", "gl", "gu", "gv", "ha", "he", "hi", "hr", "hu", "hy", "id", "ig", "ii", "in", "is", "it", "iu", "iw", "ja", "ji", "jv", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "kw", "ky", "lb", "lg", "ln", "lo", "lt", "lv", "mg", "mk", "ml", "mn", "mr", "ms", "mt", "my", "nb", "nd", "ne", "nl", "nn", "no", "nr", "ny", "om", "or", "os", "pa", "pl", "ps", "pt", "rm", "ro", "ru", "se", "sg", "si", "sk", "sl", "sn", "so", "sq", "sr", "ss", "st", "sv", "sw", "ta", "te", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "zh", "zu"};
    private static final int[] FLAGS = new int[]{2, 66, 66, 31, 66, 2, 90, 2, 66, 0, 66, 0, 222, 74, 2, 2, 10, 31, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 66, 66, 2, 2, 66, 2, 30, 206, 2, 66, 206, 2, 22, 66, 74, 2, 66, 0, 0, 0, 0, 66, 2, 6, 22, 0, 2, 0, 2, 2, 2, 0, 66, 0, 2, 2, 6, 2, 2, 2, 66, 0, 74, 99, 66, 66, 2, 2, 66, 0, 26, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 66, 26, 2, 66, 2, 10, 90, 6, 0, 66, 10, 206, 2, 2, 2, 74, 2, 2, 2, 2, 2, 2, 0, 66, 2, 66, 2, 0, 2, 2, 2, 90, 2, 2, 2, 0, 2, 66, 0, 2, 2, 0, 0, 66};

    @NonNull
    public static PluralsDatabase get() {
        return sInstance;
    }

    private static int getFlags(@NonNull String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        if (index != -1) {
            return FLAGS[index];
        }
        return 0;
    }

    private static int getLanguageIndex(@NonNull String language) {
        int index = Arrays.binarySearch(LANGUAGE_CODES, language);
        if (index >= 0) {
            assert (LANGUAGE_CODES[index].equals(language));
            return index;
        }
        return -1;
    }

    @Nullable
    public EnumSet<Quantity> getRelevant(@NonNull String language) {
        EnumSet<Quantity> set = this.mPlurals.get(language);
        if (set == null) {
            int index = PluralsDatabase.getLanguageIndex(language);
            if (index == -1) {
                this.mPlurals.put(language, NONE);
                return null;
            }
            int flag = FLAGS[index];
            set = EnumSet.noneOf(Quantity.class);
            if ((flag & 1) != 0) {
                set.add(Quantity.zero);
            }
            if ((flag & 2) != 0) {
                set.add(Quantity.one);
            }
            if ((flag & 4) != 0) {
                set.add(Quantity.two);
            }
            if ((flag & 8) != 0) {
                set.add(Quantity.few);
            }
            if ((flag & 0x10) != 0) {
                set.add(Quantity.many);
            }
            this.mPlurals.put(language, set);
        }
        return set == NONE ? null : set;
    }

    public boolean hasMultipleValuesForQuantity(@NonNull String language, @NonNull Quantity quantity) {
        if (quantity == Quantity.one) {
            return (PluralsDatabase.getFlags(language) & 0x40) != 0;
        }
        if (quantity == Quantity.two) {
            return (PluralsDatabase.getFlags(language) & 0x80) != 0;
        }
        return quantity == Quantity.zero && (PluralsDatabase.getFlags(language) & 0x20) != 0;
    }

    @Nullable
    public String findIntegerExamples(@NonNull String language, @NonNull Quantity quantity) {
        if (quantity == Quantity.one) {
            return PluralsDatabase.getExampleForQuantityOne(language);
        }
        if (quantity == Quantity.two) {
            return PluralsDatabase.getExampleForQuantityTwo(language);
        }
        if (quantity == Quantity.zero) {
            return PluralsDatabase.getExampleForQuantityZero(language);
        }
        return null;
    }

    @Nullable
    private static String getExampleForQuantityZero(@NonNull String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 72: {
                return "0, 10~20, 30, 40, 50, 60, 100, 1000, 10000, 100000, 1000000, \u2026";
            }
        }
        return null;
    }

    @Nullable
    private static String getExampleForQuantityOne(@NonNull String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 2: 
            case 4: 
            case 10: 
            case 29: 
            case 38: 
            case 42: 
            case 61: 
            case 77: 
            case 135: {
                return "0, 1";
            }
            case 50: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 74: {
                return "1, 11, 21, 31, 41, 51, 61, 71, 101, 1001, \u2026";
            }
            case 117: {
                return "0~3, 5, 7, 8, 10~13, 15, 17, 18, 20, 21, 100, 1000, 10000, 100000, 1000000, \u2026";
            }
            case 72: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 30: 
            case 33: 
            case 45: {
                return "0, 1";
            }
            case 13: 
            case 43: 
            case 107: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 36: {
                return "1, 11";
            }
            case 103: {
                return "1, 101, 201, 301, 401, 501, 601, 701, 1001, \u2026";
            }
            case 6: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 71: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 98: 
            case 123: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 12: {
                return "1, 21, 31, 41, 51, 61, 81, 101, 1001, \u2026";
            }
            case 39: {
                return "1, 11, 21, 31, 41, 51, 61, 71, 101, 1001, \u2026";
            }
            case 101: {
                return "0, 1";
            }
            case 1: 
            case 8: 
            case 69: 
            case 73: 
            case 92: 
            case 115: 
            case 129: {
                return "0, 1";
            }
            case 95: {
                return "0, 1";
            }
        }
        return null;
    }

    @Nullable
    private static String getExampleForQuantityTwo(@NonNull String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 36: {
                return "2, 12";
            }
            case 103: {
                return "2, 102, 202, 302, 402, 502, 602, 702, 1002, \u2026";
            }
            case 12: {
                return "2, 22, 32, 42, 52, 62, 82, 102, 1002, \u2026";
            }
            case 39: {
                return "2, 12, 22, 32, 42, 52, 62, 72, 102, 1002, \u2026";
            }
        }
        return null;
    }

    public static enum Quantity {
        few,
        many,
        one,
        two,
        zero,
        other;


        @Nullable
        public static Quantity get(@NonNull String name) {
            for (Quantity quantity : Quantity.values()) {
                if (!name.equals(quantity.name())) continue;
                return quantity;
            }
            return null;
        }

        public static String formatSet(@NonNull EnumSet<Quantity> set) {
            ArrayList<String> list = new ArrayList<String>(set.size());
            for (Quantity quantity : set) {
                list.add('`' + quantity.name() + '`');
            }
            return LintUtils.formatList(list, Integer.MAX_VALUE);
        }
    }
}

