/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

public class OverrideConcreteDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("OverrideAbstract", "Not overriding abstract methods on older platforms", "To improve the usability of some APIs, some methods that used to be `abstract` have been made concrete by adding default implementations. This means that when compiling with new versions of the SDK, your code does not have to override these methods.\n\nHowever, if your code is also targeting older versions of the platform where these methods were still `abstract`, the code will crash. You must override all methods that used to be abstract in any versions targeted by your application's `minSdkVersion`.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(OverrideConcreteDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String NOTIFICATION_LISTENER_SERVICE_FQN = "android.service.notification.NotificationListenerService";
    public static final String STATUS_BAR_NOTIFICATION_FQN = "android.service.notification.StatusBarNotification";
    private static final String ON_NOTIFICATION_POSTED = "onNotificationPosted";
    private static final String ON_NOTIFICATION_REMOVED = "onNotificationRemoved";
    private static final int CONCRETE_IN = 21;

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(NOTIFICATION_LISTENER_SERVICE_FQN);
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass declaration2) {
        String[] methodNames;
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration2)) {
            return;
        }
        int minSdk = Math.max(context.getProject().getMinSdk(), OverrideConcreteDetector.getTargetApi((PsiClass)declaration2));
        if (minSdk >= 21) {
            return;
        }
        for (String methodName2 : methodNames = new String[]{ON_NOTIFICATION_POSTED, ON_NOTIFICATION_REMOVED}) {
            boolean found = false;
            for (PsiMethod method : declaration2.findMethodsByName(methodName2, true)) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || NOTIFICATION_LISTENER_SERVICE_FQN.equals(containingClass.getQualifiedName()) || evaluator.isAbstract((PsiModifierListOwner)method) || method.getParameterList().getParametersCount() != 1 || !evaluator.parameterHasType(method, 0, STATUS_BAR_NOTIFICATION_FQN)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String message = String.format("Must override `%1$s.%2$s(%3$s)`: Method was abstract until %4$d, and your `minSdkVersion` is %5$d", NOTIFICATION_LISTENER_SERVICE_FQN, methodName2, STATUS_BAR_NOTIFICATION_FQN, 21, minSdk);
            context.reportUast(ISSUE, (UElement)declaration2, context.getUastNameLocation((UElement)declaration2), message);
            break;
        }
    }

    private static int getTargetApi(@NonNull PsiClass node) {
        while (node != null) {
            int targetApi = ApiDetector.getTargetApi(node.getModifierList());
            if (targetApi != -1) {
                return targetApi;
            }
            node = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)node, PsiClass.class, (boolean)true);
        }
        return -1;
    }
}

