/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CutPasteDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("CutPasteId", "Likely cut & paste mistakes", "This lint check looks for cases where you have cut & pasted calls to `findViewById` but have forgotten to update the R.id field. It's possible that your code is simply (redundantly) looking up the field repeatedly, but lint cannot distinguish that from a case where you for example want to initialize fields `prev` and `next` and you cut & pasted `findViewById(R.id.prev)` and forgot to update the second initialization to `R.id.next`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CutPasteDetector.class, Scope.JAVA_FILE_SCOPE));
    private PsiMethod mLastMethod;
    private Map<String, UCallExpression> mIds;
    private Map<String, String> mLhs;
    private Map<String, String> mCallOperands;

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("findViewById");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod calledMethod) {
        String lhs = CutPasteDetector.getLhs(call);
        if (lhs == null) {
            return;
        }
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)call, UMethod.class, (boolean)false);
        if (method == null) {
            return;
        }
        if (method != this.mLastMethod) {
            this.mIds = Maps.newHashMap();
            this.mLhs = Maps.newHashMap();
            this.mCallOperands = Maps.newHashMap();
            this.mLastMethod = method;
        }
        String callOperand = call.getReceiver() != null ? call.getReceiver().asSourceString() : "";
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        if (first instanceof UReferenceExpression) {
            UReferenceExpression type2;
            UExpression operand2;
            UReferenceExpression psiReferenceExpression = (UReferenceExpression)first;
            String id = psiReferenceExpression.getResolvedName();
            UExpression uExpression = operand2 = first instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)first).getReceiver() : null;
            if (operand2 instanceof UReferenceExpression && "id".equals((type2 = (UReferenceExpression)operand2).getResolvedName())) {
                if (this.mIds.containsKey(id)) {
                    if (lhs.equals(this.mLhs.get(id))) {
                        return;
                    }
                    if (!callOperand.equals(this.mCallOperands.get(id))) {
                        return;
                    }
                    UCallExpression earlierCall = this.mIds.get(id);
                    if (!CutPasteDetector.isReachableFrom(method, (UElement)earlierCall, (UElement)call)) {
                        return;
                    }
                    Location location = context.getUastLocation((UElement)call);
                    Location secondary = context.getUastLocation((UElement)earlierCall);
                    secondary.setMessage("First usage here");
                    location.setSecondary(secondary);
                    context.report(ISSUE, (UElement)call, location, String.format("The id `%1$s` has already been looked up in this method; possible cut & paste error?", first.asSourceString()));
                } else {
                    this.mIds.put(id, call);
                    this.mLhs.put(id, lhs);
                    this.mCallOperands.put(id, callOperand);
                }
            }
        }
    }

    @Nullable
    private static String getLhs(@NonNull UCallExpression call) {
        for (UElement parent = call.getUastParent(); parent != null && !(parent instanceof UBlockExpression); parent = parent.getUastParent()) {
            if (parent instanceof ULocalVariable) {
                return ((ULocalVariable)parent).getName();
            }
            if (!UastExpressionUtils.isAssignment((UElement)parent)) continue;
            UExpression left = ((UBinaryExpression)parent).getLeftOperand();
            if (left instanceof UReferenceExpression) {
                return left.asSourceString();
            }
            if (!(left instanceof UArrayAccessExpression)) continue;
            UArrayAccessExpression aa = (UArrayAccessExpression)left;
            return aa.getReceiver().asSourceString();
        }
        return null;
    }

    static boolean isReachableFrom(@NonNull UMethod method, @NonNull UElement from, @NonNull UElement to) {
        ReachabilityVisitor visitor = new ReachabilityVisitor(from, to);
        method.accept((UastVisitor)visitor);
        return visitor.isReachable();
    }

    private static class ReachabilityVisitor
    extends AbstractUastVisitor {
        private final UElement mFrom;
        private final UElement mTarget;
        private boolean mIsFromReached;
        private boolean mIsTargetReachable;
        private boolean mIsFinished;
        private UExpression mBreakedExpression;
        private UExpression mContinuedExpression;

        ReachabilityVisitor(UElement from, UElement target) {
            this.mFrom = from;
            this.mTarget = target;
        }

        public boolean visitElement(UElement node) {
            if (this.mIsFinished || this.mBreakedExpression != null || this.mContinuedExpression != null) {
                return true;
            }
            if (node.equals(this.mFrom)) {
                this.mIsFromReached = true;
            }
            if (node.equals(this.mTarget)) {
                this.mIsFinished = true;
                if (this.mIsFromReached) {
                    this.mIsTargetReachable = true;
                }
                return true;
            }
            if (this.mIsFromReached) {
                if (node instanceof UReturnExpression) {
                    this.mIsFinished = true;
                } else if (node instanceof UBreakExpression) {
                    this.mBreakedExpression = ReachabilityVisitor.getBreakedExpression((UBreakExpression)node);
                } else if (node instanceof UContinueExpression) {
                    UExpression expression2 = ReachabilityVisitor.getContinuedExpression((UContinueExpression)node);
                    if (expression2 != null && UastUtils.isChildOf((UElement)this.mTarget, (UElement)expression2, (boolean)false)) {
                        this.mIsTargetReachable = true;
                        this.mIsFinished = true;
                    } else {
                        this.mContinuedExpression = expression2;
                    }
                } else if (UastUtils.isChildOf((UElement)this.mTarget, (UElement)node, (boolean)false)) {
                    this.mIsTargetReachable = true;
                    this.mIsFinished = true;
                }
                return true;
            }
            if (node instanceof UIfExpression) {
                UExpression elseExpression2;
                UIfExpression ifExpression2 = (UIfExpression)node;
                ifExpression2.getCondition().accept((UastVisitor)this);
                boolean isFromReached = this.mIsFromReached;
                UExpression thenExpression2 = ifExpression2.getThenExpression();
                if (thenExpression2 != null) {
                    thenExpression2.accept((UastVisitor)this);
                }
                if ((elseExpression2 = ifExpression2.getElseExpression()) != null && isFromReached == this.mIsFromReached) {
                    elseExpression2.accept((UastVisitor)this);
                }
                return true;
            }
            if (node instanceof ULoopExpression) {
                this.visitLoopExpressionHeader(node);
                boolean isFromReached = this.mIsFromReached;
                ((ULoopExpression)node).getBody().accept((UastVisitor)this);
                if (isFromReached != this.mIsFromReached && UastUtils.isChildOf((UElement)this.mTarget, (UElement)node, (boolean)false)) {
                    this.mIsTargetReachable = true;
                    this.mIsFinished = true;
                }
                return true;
            }
            return false;
        }

        public void afterVisitElement(UElement node) {
            if (node.equals(this.mBreakedExpression)) {
                this.mBreakedExpression = null;
            } else if (node.equals(this.mContinuedExpression)) {
                this.mContinuedExpression = null;
            }
        }

        private void visitLoopExpressionHeader(UElement node) {
            if (node instanceof UWhileExpression) {
                ((UWhileExpression)node).getCondition().accept((UastVisitor)this);
            } else if (node instanceof UDoWhileExpression) {
                ((UDoWhileExpression)node).getCondition().accept((UastVisitor)this);
            } else if (node instanceof UForExpression) {
                UForExpression forExpression = (UForExpression)node;
                if (forExpression.getDeclaration() != null) {
                    forExpression.getDeclaration().accept((UastVisitor)this);
                }
                if (forExpression.getCondition() != null) {
                    forExpression.getCondition().accept((UastVisitor)this);
                }
                if (forExpression.getUpdate() != null) {
                    forExpression.getUpdate().accept((UastVisitor)this);
                }
            } else if (node instanceof UForEachExpression) {
                UForEachExpression forEachExpression = (UForEachExpression)node;
                forEachExpression.getForIdentifier().accept((UastVisitor)this);
                forEachExpression.getIteratedValue().accept((UastVisitor)this);
            }
        }

        private static UExpression getBreakedExpression(UBreakExpression node) {
            String label = node.getLabel();
            for (UElement parent = node.getUastParent(); parent != null; parent = parent.getUastParent()) {
                if (label != null) {
                    ULabeledExpression labeledExpression;
                    if (!(parent instanceof ULabeledExpression) || !(labeledExpression = (ULabeledExpression)parent).getLabel().equals(label)) continue;
                    return labeledExpression.getExpression();
                }
                if (!(parent instanceof ULoopExpression) && !(parent instanceof USwitchExpression)) continue;
                return (UExpression)parent;
            }
            return null;
        }

        private static UExpression getContinuedExpression(UContinueExpression node) {
            String label = node.getLabel();
            for (UElement parent = node.getUastParent(); parent != null; parent = parent.getUastParent()) {
                if (label != null) {
                    ULabeledExpression labeledExpression;
                    if (!(parent instanceof ULabeledExpression) || !(labeledExpression = (ULabeledExpression)parent).getLabel().equals(label)) continue;
                    return labeledExpression.getExpression();
                }
                if (!(parent instanceof ULoopExpression)) continue;
                return (UExpression)parent;
            }
            return null;
        }

        public boolean isReachable() {
            return this.mIsTargetReachable;
        }
    }
}

