/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.List;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CommentDetector
extends Detector
implements Detector.UastScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue EASTER_EGG = Issue.create("EasterEgg", "Code contains easter egg", "An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create("StopShip", "Code contains `STOPSHIP` marker", "Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these.", Category.CORRECTNESS, 10, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";
    private static final boolean USE_AST = false;

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return null;
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        String source = context.getContents();
        if (source == null) {
            return null;
        }
        int n = source.length() - 1;
        for (int i = 0; i < n; ++i) {
            int end;
            int start;
            char c = source.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '/') continue;
            char next = source.charAt(i + 1);
            if (next == '/') {
                start = i + 2;
                end = source.indexOf(10, start);
                if (end == -1) {
                    end = n;
                }
                CommentDetector.checkComment(context, null, source, 0, start, end);
                continue;
            }
            if (next != '*') continue;
            start = i + 2;
            end = source.indexOf("*/", start);
            if (end == -1) {
                end = n;
            }
            CommentDetector.checkComment(context, null, source, 0, start, end);
        }
        return null;
    }

    private static void checkComment(@NonNull JavaContext context, @Nullable UComment node, @NonNull String source, int offset, int start, int end) {
        int prev = 0;
        for (int i = start; i < end - 2; ++i) {
            Location location;
            char c = source.charAt(i);
            if (prev == 92) {
                if (c == 'u' || c == 'U') {
                    if (source.regionMatches(true, i - 1, ESCAPE_STRING, 0, ESCAPE_STRING.length())) {
                        location = Location.create(context.file, source, offset + i - 1, offset + i - 1 + ESCAPE_STRING.length());
                        context.report(EASTER_EGG, (UElement)node, location, "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows");
                    }
                } else {
                    ++i;
                }
            } else if (prev == 83 && c == 'T' && source.regionMatches(i - 1, STOPSHIP_COMMENT, 0, STOPSHIP_COMMENT.length())) {
                location = node != null ? context.getUastLocation((UElement)node) : Location.create(context.file, source, offset + i - 1, offset + i - 1 + STOPSHIP_COMMENT.length());
                context.report(STOP_SHIP, (UElement)node, location, "`STOPSHIP` comment found; points to code which must be fixed prior to release");
            }
            prev = c;
        }
    }

    private static class CommentChecker
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        public CommentChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitFile(UFile node) {
            for (UComment comment : node.getAllCommentsInFile()) {
                String contents = comment.getText();
                CommentDetector.checkComment(this.mContext, comment, contents, comment.getPsi().getTextRange().getStartOffset(), 0, contents.length());
            }
            return super.visitFile(node);
        }
    }
}

