/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.CharArrayCharSequence;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MyBuilder;
import org.intellij.markdown.parser.MyRawBuilder;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser;", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;)V", "buildMarkdownTreeFromString", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "parse", "root", "Lorg/intellij/markdown/IElementType;", "textString", "parseInlines", "", "parseInline", "", "textStart", "", "textEnd", "InlineExpandingASTNodeBuilder", "52a7eb3df0584991"})
public final class MarkdownParser {
    private final MarkdownFlavourDescriptor flavour;

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.parse(MarkdownElementTypes.MARKDOWN_FILE, text, true);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String textString, boolean parseInlines) {
        CharArrayCharSequence charArrayCharSequence;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)textString, (String)"textString");
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        String string = textString;
        CharArrayCharSequence charArrayCharSequence2 = charArrayCharSequence;
        CharArrayCharSequence charArrayCharSequence3 = charArrayCharSequence;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        charArrayCharSequence2(cArray2, 0, 0, 6, null);
        CharArrayCharSequence text = charArrayCharSequence3;
        LookaheadText textHolder = new LookaheadText(text);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(text.length());
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text) : new ASTNodeBuilder(text);
        MyRawBuilder builder = new MyRawBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ASTNode parse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.parse(iElementType, string, bl);
    }

    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text, int textStart, int textEnd) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        lexer.start(text, textStart, textEnd);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        int n = 0;
        IntRange wholeRange = new IntRange(n, tokensCache.getFilteredTokens().size());
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.Companion.filterBlockquotes(tokensCache, wholeRange));
        return new MyBuilder(new ASTNodeBuilder(text), tokensCache).buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node(wholeRange, root))));
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        this.flavour = flavour;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser$InlineExpandingASTNodeBuilder;", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "text", "", "(Lorg/intellij/markdown/parser/MarkdownParser;Ljava/lang/CharSequence;)V", "createLeafNodes", "", "Lorg/intellij/markdown/ast/ASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "startOffset", "", "endOffset", "52a7eb3df0584991"})
    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        @Override
        @NotNull
        public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            IElementType iElementType = type;
            return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ATX_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SETEXT_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL) ? CollectionsKt.listOf((Object)MarkdownParser.this.parseInline(type, this.getText(), startOffset, endOffset)) : super.createLeafNodes(type, startOffset, endOffset);
        }

        public InlineExpandingASTNodeBuilder(CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            super(text);
        }
    }
}

