/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aR\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider;", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;)V", "inlineLinkProvider", "Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "getInlineLinkProvider", "()Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "referenceLinkProvider", "Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getReferenceLinkProvider", "()Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getPlainTextFrom", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "Companion", "52a7eb3df0584991"})
public final class ImageGeneratingProvider
extends LinkGeneratingProvider {
    @NotNull
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    @NotNull
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    @NotNull
    private static final Regex REGEX;
    public static final Companion Companion;

    @NotNull
    public final ReferenceLinksGeneratingProvider getReferenceLinkProvider() {
        return this.referenceLinkProvider;
    }

    @NotNull
    public final InlineLinkGeneratingProvider getInlineLinkProvider() {
        return this.inlineLinkProvider;
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        ASTNode aSTNode = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.INLINE_LINK);
        if (aSTNode != null) {
            ASTNode aSTNode2;
            ASTNode linkNode = aSTNode2 = aSTNode;
            return this.inlineLinkProvider.getRenderInfo(text, linkNode);
        }
        ASTNode aSTNode3 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.FULL_REFERENCE_LINK);
        if (aSTNode3 == null) {
            aSTNode3 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.SHORT_REFERENCE_LINK);
        }
        if (aSTNode3 != null) {
            ASTNode aSTNode4;
            ASTNode linkNode = aSTNode4 = aSTNode3;
            return this.referenceLinkProvider.getRenderInfo(text, linkNode);
        }
        return null;
    }

    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        CharSequence[] charSequenceArray;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        boolean bl = true;
        CharSequence[] charSequenceArray2 = new CharSequence[3];
        charSequenceArray2[0] = "src=\"" + this.makeAbsoluteUrl(info.getDestination()) + '\"';
        charSequenceArray2[1] = "alt=\"" + this.getPlainTextFrom(info.getLabel(), text) + '\"';
        CharSequence[] charSequenceArray3 = charSequenceArray2;
        CharSequence[] charSequenceArray4 = charSequenceArray2;
        int n = 2;
        CharSequence[] charSequenceArray5 = info.getTitle();
        if (charSequenceArray5 != null) {
            charSequenceArray = charSequenceArray5;
            int n2 = n;
            CharSequence[] charSequenceArray6 = charSequenceArray3;
            CharSequence[] charSequenceArray7 = charSequenceArray4;
            boolean bl2 = bl;
            CharSequence charSequence2 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            CharSequence[] it = charSequenceArray;
            String string2 = "title=\"" + (CharSequence)it + '\"';
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence2;
            bl = bl2;
            charSequenceArray4 = charSequenceArray7;
            charSequenceArray3 = charSequenceArray6;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray3[n] = string;
        charSequenceArray = charSequenceArray4;
        boolean bl3 = bl;
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl3);
    }

    private final CharSequence getPlainTextFrom(ASTNode node, String text) {
        return Companion.getREGEX().replace(ASTUtilKt.getTextInNode(node, text), "");
    }

    public ImageGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        super(baseURI);
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap, baseURI);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider(baseURI);
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("[^a-zA-Z0-9 ]");
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "52a7eb3df0584991"})
    public static final class Companion {
        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

