/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;

public class HerokuBashSessionHelper {
    private final CloudDeploymentRuntime myDeploymentRuntime;

    public HerokuBashSessionHelper(CloudDeploymentRuntime deploymentRuntime) {
        this.myDeploymentRuntime = deploymentRuntime;
    }

    public void setupHyperlink() {
        DeploymentLogManager myLogManager = this.myDeploymentRuntime.getLogManager();
        if (myLogManager == null) {
            return;
        }
        LoggingHandler loggingHandler = myLogManager.getMainLoggingHandler();
        loggingHandler.print("Access your application using ");
        loggingHandler.printHyperlink("Bash session...", new HyperlinkInfo(){

            public void navigate(Project project) {
                HerokuBashSessionHelper.this.startBashSession();
            }
        });
        loggingHandler.print("\n");
    }

    private void startBashSession() {
        this.myDeploymentRuntime.getTaskExecutor().submit(() -> {
            try {
                this.myDeploymentRuntime.getAgentTaskExecutor().execute(() -> {
                    ((HerokuCloudAgentDeployment)this.myDeploymentRuntime.getDeployment()).startBashSession();
                    return null;
                });
            }
            catch (ServerRuntimeException e) {
                this.myDeploymentRuntime.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }
}

