/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class EnableConfigurationPropertiesModel
extends LocalAnnotationModel {
    @NonNls
    private static final String CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX = "CONFIGURATION_PROPERTIES";
    private final EnableConfigurationProperties myEnableConfigurationProperties;
    private final LocalAnnotationModel myLocalAnnotationModel;

    EnableConfigurationPropertiesModel(LocalAnnotationModel localAnnotationModel, EnableConfigurationProperties enableConfigurationProperties) {
        this.myEnableConfigurationProperties = enableConfigurationProperties;
        this.myLocalAnnotationModel = localAnnotationModel;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        final boolean isAtLeast14 = SpringBootLibraryUtil.isAtLeastVersion((Module)this.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);
        SmartList beans = new SmartList();
        for (final PsiClass configBeanClass : this.myEnableConfigurationProperties.getValue()) {
            final ConfigurationProperties configurationProperties = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)configBeanClass);
            if (configurationProperties == null) continue;
            CustomSpringComponent bean = new CustomSpringComponent("org.springframework.boot.context.properties.ConfigurationProperties", configBeanClass){

                public String getBeanName() {
                    String prefix = configurationProperties.getValueOrPrefix();
                    boolean hasPrefix = StringUtil.isNotEmpty((String)prefix);
                    String qualifiedName = configBeanClass.getQualifiedName();
                    if (isAtLeast14) {
                        return hasPrefix ? prefix + "-" + qualifiedName : qualifiedName;
                    }
                    return hasPrefix ? prefix + "." + EnableConfigurationPropertiesModel.CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX : qualifiedName;
                }
            };
            beans.add(bean);
        }
        return BeanService.getInstance().mapSpringBeans((Collection)beans);
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myEnableConfigurationProperties.getPsiElement();
        if (psiClass == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Set<Pair<LocalModel, LocalModelDependency>> set = Collections.emptySet();
        if (set == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(2);
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            EnableConfigurationPropertiesModel.$$$reportNull$$$0(6);
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EnableConfigurationPropertiesModel model = (EnableConfigurationPropertiesModel)((Object)o);
        if (!this.myEnableConfigurationProperties.equals(model.myEnableConfigurationProperties)) {
            return false;
        }
        return this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myEnableConfigurationProperties.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

