/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootApplicationFileSet;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelExtender;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelProvider
implements SpringModelProvider {
    @NotNull
    public List<SpringFileSet> getFilesets(@NotNull SpringFacet facet) {
        Module module;
        if (facet == null) {
            SpringBootModelProvider.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)(module = facet.getModule()))) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Project project = module.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            PsiClass applicationClass;
            if (facet == null) {
                SpringBootModelProvider.$$$reportNull$$$0(3);
            }
            if ((applicationClass = SpringBootModelProvider.findSingleSpringBootApplication(module)) == null || applicationClass.getQualifiedName() == null) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            SpringBootApplicationFileSet bootFileSet = new SpringBootApplicationFileSet(applicationClass, facet);
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                for (VirtualFile file : contributor.getConfigurationFiles(module, (SpringFileSet)bootFileSet, false)) {
                    bootFileSet.addFile(file);
                }
            }
            SpringFacetConfiguration configuration = (SpringFacetConfiguration)facet.getConfiguration();
            configuration.registerAutodetectedFileSet((SpringFileSet)bootFileSet);
            ModificationTracker springOuterModelsTracker = SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsModificationTracker();
            List fileSets = ContainerUtil.newSmartList((Object)((Object)bootFileSet));
            for (SpringBootModelExtender extender : (SpringBootModelExtender[])SpringBootModelExtender.EP_NAME.getExtensions()) {
                fileSets.addAll(extender.getAdditionalFileSets((SpringFileSet)bootFileSet));
            }
            return CachedValueProvider.Result.create((Object)fileSets, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, springOuterModelsTracker, configuration});
        });
        if (list == null) {
            SpringBootModelProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getName() {
        return "Spring Boot";
    }

    @Nullable
    private static PsiClass findSingleSpringBootApplication(Module module) {
        List results = SpringBootApplicationUtil.getSpringApplications((Module)module);
        return results.size() == 1 ? (PsiClass)ContainerUtil.getFirstItem((List)results) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilesets$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

