/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @NotNull
    public List<SpringBootModelConfigFileContributor.ConfigurationValueResult> findConfigurationValues(PsiFile configFile, SpringBootApplicationMetaConfigKey key, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles) {
        PropertiesFile propertiesFile = SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantFile(configFile, activeProfiles);
        if (propertiesFile == null) {
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String keyName = key.getName();
        if (key.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL, SpringBootApplicationMetaConfigKey.AccessType.INDEXED})) {
            IProperty byExactName = propertiesFile.findPropertyByKey(keyName);
            if (byExactName != null) {
                PropertyImpl propertyImpl = (PropertyImpl)byExactName.getPsiElement();
                List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.singletonList(new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl), (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), byExactName.getValue()));
                if (list == null) {
                    SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(1);
                }
                return list;
            }
            if (!checkRelaxedNames && key.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL})) {
                List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
                if (list == null) {
                    SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        boolean multipleOccurrencesPossible = key.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP, SpringBootApplicationMetaConfigKey.AccessType.MAP, SpringBootApplicationMetaConfigKey.AccessType.INDEXED});
        SmartList results = new SmartList();
        for (IProperty property : propertiesFile.getProperties()) {
            ProgressManager.checkCanceled();
            String propertyName = property.getName();
            if (propertyName == null || !checkRelaxedNames && !propertyName.startsWith(keyName) || !key.matches(propertyName)) continue;
            PropertyImpl element = (PropertyImpl)property.getPsiElement();
            SpringBootModelConfigFileContributor.ConfigurationValueResult result = new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)SpringBootApplicationPropertiesUtil.getPropertyKey(element), (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(element), property.getValue());
            results.add(result);
            if (multipleOccurrencesPossible) continue;
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Nullable
    private static PropertiesFile isProfileRelevantFile(PsiFile configFile, @Nullable Set<String> activeProfiles) {
        if (!(configFile instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)configFile;
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return propertiesFile;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return null;
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? propertiesFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor", "findConfigurationValues"));
    }
}

