/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.facet.FacetFinder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesUtil {
    public static boolean isApplicationPropertiesFile(PropertiesFile propertiesFile) {
        PsiFile containingFile = propertiesFile.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)containingFile, () -> {
            VirtualFile virtualFile = containingFile.getVirtualFile();
            boolean found = false;
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                if (contributor.getFileType() != PropertiesFileType.INSTANCE) continue;
                List files = contributor.getConfigurationFiles(module, true);
                found = files.contains(virtualFile);
                break;
            }
            ArrayList dependencies = ContainerUtil.newArrayList((Object[])new Object[]{containingFile, FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID), ProjectRootManager.getInstance((Project)module.getProject())});
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet != null) {
                dependencies.add(springFacet.getConfiguration());
            }
            return CachedValueProvider.Result.create((Object)found, (Collection)dependencies);
        });
    }

    @Nullable
    static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }
}

