/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.ObjectUtils;

public class SpringBootAdditionalConfigConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    protected boolean processModule(MethodReferencesSearch.SearchParameters queryParameters, String prefix, Module module) {
        if (!SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor((Module)module)) {
            return true;
        }
        SpringBootAdditionalConfigUtils utils = new SpringBootAdditionalConfigUtils(module);
        return utils.processAdditionalMetadataFiles(file -> {
            JsonObject topValue = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
            if (topValue == null) {
                return true;
            }
            JsonProperty hints = topValue.findProperty("hints");
            if (hints == null) {
                return true;
            }
            JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)hints.getValue(), JsonArray.class);
            if (array == null) {
                return true;
            }
            for (JsonValue value : array.getValueList()) {
                PsiReference[] psiReferences;
                JsonStringLiteral nameValue;
                JsonProperty nameProperty;
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.startsWith((CharSequence)nameValue.getValue(), (CharSequence)prefix) || SpringBootAdditionalConfigConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences((MethodReferencesSearch.SearchParameters)queryParameters, (PsiReference[])(psiReferences = nameValue.getReferences()))) continue;
                return false;
            }
            return true;
        });
    }

    protected boolean processModelConfigFiles(MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, String prefix, Module module, SpringBootModelConfigFileContributor contributor) {
        return true;
    }
}

