/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.ValueHintPsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValueHintReferenceProvider
extends PsiReferenceProvider {
    private final List<SpringBootApplicationMetaConfigKey.ValueHint> myValueHints;
    private final SpringBootApplicationMetaConfigKey myConfigKey;
    private final int myStartInElement;
    private final boolean myAllowOtherValues;

    ValueHintReferenceProvider(SpringBootApplicationMetaConfigKey configKey, List<SpringBootApplicationMetaConfigKey.ValueHint> valueHints, String prefix, boolean allowOtherValues) {
        this.myConfigKey = configKey;
        this.myValueHints = valueHints;
        this.myStartInElement = prefix.length();
        this.myAllowOtherValues = allowOtherValues;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        TextRange valueRange;
        if (element == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((valueRange = ElementManipulators.getValueTextRange((PsiElement)element)).getLength() < this.myStartInElement) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ValueHintReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange shiftTextRange = valueRange.shiftRight(this.myStartInElement).grown(-this.myStartInElement);
        PsiReference[] psiReferenceArray = new PsiReference[]{new HintReferenceBase(element, shiftTextRange){

            public TextAttributesKey getTextAttributesKey() {
                return DefaultLanguageHighlighterColors.INSTANCE_METHOD;
            }

            public boolean isSoft() {
                return ValueHintReferenceProvider.this.myAllowOtherValues;
            }

            @Nullable
            protected PsiElement doResolve() {
                String value = this.getValue();
                SpringBootApplicationMetaConfigKey.ValueHint valueHint = (SpringBootApplicationMetaConfigKey.ValueHint)ContainerUtil.find((Iterable)ValueHintReferenceProvider.this.myValueHints, hint -> hint.getValue().equals(value));
                return valueHint != null ? new ValueHintPsiElement(this.getElement(), valueHint) : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = ContainerUtil.map2Array((Collection)ValueHintReferenceProvider.this.myValueHints, LookupElementBuilder.class, hint -> {
                    LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)new ValueHintPsiElement(this.getElement(), hint)).withBoldness(hint.getValue().equals(ValueHintReferenceProvider.this.myConfigKey.getDefaultValue()));
                    String shortDescriptionText = hint.getDescriptionText().getShortText();
                    if (StringUtil.isNotEmpty((String)shortDescriptionText)) {
                        builder = builder.appendTailText(" (" + shortDescriptionText + ")", true);
                    }
                    return builder.withIcon(SpringBootApiIcons.SpringBoot);
                });
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String[] valueHintNames = (String[])ContainerUtil.map2Array((Collection)ValueHintReferenceProvider.this.myValueHints, String.class, hint -> "''" + hint.getValue() + "''");
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])valueHintNames, (String)"|");
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }};
        if (psiReferenceArray == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

