/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DurationReferenceProvider
extends PsiReferenceProvider {
    private static final Pattern ISO8601 = Pattern.compile("^[+\\-]?P.*$");
    private static final Pattern SB2_PATTERN = Pattern.compile("^([+\\-]?\\d+)(ns|ms|s|m|h|d)$", 2);

    DurationReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DurationReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DurationReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new HintReferenceBase(element){

            @Nullable
            protected PsiElement doResolve() {
                if (ISO8601.matcher(this.getValue()).matches()) {
                    try {
                        Duration.parse(this.getValue());
                        return this.getElement();
                    }
                    catch (DateTimeParseException e) {
                        return null;
                    }
                }
                if (this.isSpringBoot2() && SB2_PATTERN.matcher(this.getValue()).matches()) {
                    return this.getElement();
                }
                return null;
            }

            private boolean isSpringBoot2() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0);
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                if ("Value ''{0}'' is not a valid duration" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Value ''{0}'' is not a valid duration";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/DurationReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }};
        if (psiReferenceArray == null) {
            DurationReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/DurationReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/DurationReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

