/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateViewResolverFactory
extends ViewResolverFactory {
    private final String myBeanClass;
    private final String myConfigurerClass;
    private final String myLoaderProperty;
    private final String myDefaultSuffix;

    protected TemplateViewResolverFactory(String beanClass, String configurerClass, String loaderProperty, String defaultSuffix) {
        this.myBeanClass = beanClass;
        this.myConfigurerClass = configurerClass;
        this.myLoaderProperty = loaderProperty;
        this.myDefaultSuffix = defaultSuffix;
    }

    protected String getBeanClass() {
        return this.myBeanClass;
    }

    @NotNull
    protected Set<ViewResolver> doCreate(@Nullable CommonSpringBean bean, SpringModel model) {
        Module module;
        Object object = model.getModule() != null ? model.getModule() : (module = bean != null ? bean.getModule() : null);
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(0);
            }
            return set;
        }
        ViewResolver.WithPrefixSuffix resolver = ViewResolverRegistry.getInstance().createURLBasedViewResolver(((Object)((Object)this)).getClass().getName(), bean);
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)this.myConfigurerClass);
        if (configurerClass == null) {
            Set<ViewResolver.WithPrefixSuffix> set = Collections.singleton(resolver);
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(1);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.isEmpty()) {
            Set<ViewResolver.WithPrefixSuffix> set = Collections.singleton(resolver);
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(2);
            }
            return set;
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        if (configurer instanceof SpringBean || configurer instanceof ContextJavaBean) {
            String value = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)this.myLoaderProperty);
            if (value != null) {
                ViewResolver.WithPrefixSuffix viewResolver = ViewResolverRegistry.getInstance().createURLBasedViewResolver(((Object)((Object)this)).getClass().getName(), value + resolver.getPrefix(), resolver.getSuffix());
                Set<ViewResolver.WithPrefixSuffix> set = Collections.singleton(viewResolver);
                if (set == null) {
                    TemplateViewResolverFactory.$$$reportNull$$$0(3);
                }
                return set;
            }
        } else {
            Set<ViewResolver> set = Collections.singleton(this.handleCustomConfigurer(configurer, resolver));
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<ViewResolver.WithPrefixSuffix> set = Collections.singleton(resolver);
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, ViewResolver.WithPrefixSuffix resolver) {
        ViewResolver.WithPrefixSuffix withPrefixSuffix = resolver;
        if (withPrefixSuffix == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(6);
        }
        return withPrefixSuffix;
    }

    @NotNull
    public Set<ViewResolver> handleViewResolverRegistry(String methodName, PsiMethodCallExpression methodCallExpression, SpringModel servletModel) {
        if (this.getViewResolverRegistryMethodName().equals(methodName)) {
            Set<ViewResolver> set = this.getViewResolverRegistryViewResolvers(methodCallExpression, servletModel);
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set set = super.handleViewResolverRegistry(methodName, methodCallExpression, servletModel);
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(8);
        }
        return set;
    }

    protected String getViewResolverRegistryMethodName() {
        return "";
    }

    @NotNull
    private Set<ViewResolver> getViewResolverRegistryViewResolvers(PsiMethodCallExpression expression, SpringModel springModel) {
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)springModel.getModule(), (String)this.myConfigurerClass);
        if (configurerClass == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(9);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.size() != 1) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(10);
            }
            return set;
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)this.myLoaderProperty);
        ViewResolver.WithPrefixSuffix viewResolver = ViewResolverRegistry.getInstance().createURLBasedViewResolver(configurer.getBeanName() + ".handleViewResolverRegistry()", prefix, this.myDefaultSuffix);
        Set<ViewResolver.WithPrefixSuffix> set = Collections.singleton(viewResolver);
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/web/mvc/views/TemplateViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCustomConfigurer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "handleViewResolverRegistry";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverRegistryViewResolvers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

