/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.velocity;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.mvc.VelocityConfigurer;
import com.intellij.spring.web.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import org.jetbrains.annotations.NotNull;

public class VelocityViewResolverFactory
extends TemplateViewResolverFactory {
    public VelocityViewResolverFactory() {
        super("org.springframework.web.servlet.view.velocity.VelocityViewResolver", "org.springframework.web.servlet.view.velocity.VelocityConfigurer", "resourceLoaderPath", ".vm");
    }

    @Override
    protected String getViewResolverRegistryMethodName() {
        return "velocity";
    }

    @Override
    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, ViewResolver.WithPrefixSuffix resolver) {
        if (configurer instanceof VelocityConfigurer) {
            VelocityConfigurer velocityConfigurer = (VelocityConfigurer)configurer;
            String resourceLoaderPath = velocityConfigurer.getResourceLoaderPath().getStringValue();
            ViewResolver.WithPrefixSuffix withPrefixSuffix = ViewResolverRegistry.getInstance().createURLBasedViewResolver("VelocityViewResolverFactory", StringUtil.defaultIfEmpty((String)resourceLoaderPath, (String)"/WEB-INF/"), "");
            if (withPrefixSuffix == null) {
                VelocityViewResolverFactory.$$$reportNull$$$0(0);
            }
            return withPrefixSuffix;
        }
        ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
        if (viewResolver == null) {
            VelocityViewResolverFactory.$$$reportNull$$$0(1);
        }
        return viewResolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/velocity/VelocityViewResolverFactory", "handleCustomConfigurer"));
    }
}

