/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.struts.dom.tiles.TilesDefinitions;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesViewResolver
extends ViewResolver {
    private final StrutsPluginDomFactory<TilesDefinitions, TilesModel> myTilesFactory;
    private final String myID;
    private final Module myModule;

    TilesViewResolver(String ID, SpringModel model) {
        this.myID = ID;
        this.myModule = model.getModule();
        assert (this.myModule != null);
        this.myTilesFactory = StrutsProjectComponent.getInstance((Project)this.myModule.getProject()).getTilesFactory();
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            TilesViewResolver.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement resolveView(@NotNull PsiElement context, String viewName, SpringMVCModel springMVCModel) {
        Definition definition;
        if (context == null) {
            TilesViewResolver.$$$reportNull$$$0(1);
        }
        if ((definition = this.findDefinition(viewName)) == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)definition);
        if (target == null) {
            return null;
        }
        return PomService.convertToPsi((PsiTarget)target);
    }

    public PsiElement resolveFinalView(@NotNull PsiElement context, String viewName, SpringMVCModel springMVCModel) {
        Definition definition;
        if (context == null) {
            TilesViewResolver.$$$reportNull$$$0(2);
        }
        if ((definition = this.findDefinition(viewName)) == null) {
            return null;
        }
        return TilesViewResolver.resolveDefinitionTarget(definition, springMVCModel);
    }

    @Nullable
    private static PsiFile resolveDefinitionTarget(@NotNull Definition definition, SpringMVCModel context) {
        if (definition == null) {
            TilesViewResolver.$$$reportNull$$$0(3);
        }
        List puts = definition.getAllPuts();
        for (Put put : puts) {
            WebDirectoryElement webDirectoryElement;
            Definition inner = put.getDefinition();
            PsiFile directoryElement = TilesViewResolver.resolveDefinitionTarget(inner, context);
            if (directoryElement != null) {
                return directoryElement;
            }
            String value = put.getValue();
            if (StringUtil.isEmpty((String)value)) {
                value = put.getAttributeValue().getStringValue();
            }
            if (!StringUtil.isNotEmpty((String)value) || (webDirectoryElement = context.findWebDirectoryElement(value)) == null) continue;
            return webDirectoryElement.getOriginalFile();
        }
        return null;
    }

    public List<LookupElement> getAllViews(@NotNull PsiElement context, SpringMVCModel springMVCModel) {
        TilesModel tilesModel;
        if (context == null) {
            TilesViewResolver.$$$reportNull$$$0(4);
        }
        if ((tilesModel = this.getTilesModel()) == null) {
            return Collections.emptyList();
        }
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>();
        for (Definition definition : tilesModel.getDefinitions()) {
            DomTarget target = DomTarget.getTarget((DomElement)definition);
            if (target == null || target.getName() == null) continue;
            PsiElement resolvePsiElement = target.getNavigationElement();
            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)resolvePsiElement, (String)target.getName()).withIcon(StrutsApiIcons.Tiles.Tile).withTypeText(resolvePsiElement.getContainingFile().getName());
            lookupElements.add((LookupElement)lookupElement);
        }
        return lookupElements;
    }

    public String bindToElement(PsiElement element) {
        return null;
    }

    @NotNull
    public String handleElementRename(String newElementName) {
        String string = newElementName;
        if (string == null) {
            TilesViewResolver.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private TilesModel getTilesModel() {
        return (TilesModel)this.myTilesFactory.getCombinedModel((UserDataHolder)this.myModule);
    }

    @Nullable
    private Definition findDefinition(String viewName) {
        TilesModel model = this.getTilesModel();
        if (model == null) {
            return null;
        }
        return model.findDefinition(viewName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/tiles/TilesViewResolver";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/tiles/TilesViewResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveView";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveFinalView";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefinitionTarget";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllViews";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

