/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReferenceProvider;
import com.intellij.spring.web.mvc.pathVariables.MVCRequestMappingReference;
import org.jetbrains.annotations.NotNull;

public class MVCPathVariableInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final PsiJavaElementPattern.Capture<PsiReferenceExpression> REFERENCE_PATTERN = MVCPathVariableReference.createPattern(PsiReferenceExpression.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Project project;
        if (holder == null) {
            MVCPathVariableInspection.$$$reportNull$$$0(0);
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)(project = holder.getProject()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MVCPathVariableInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiReference[] pathVarReferences;
                boolean hasUnresolvedPathVariables;
                if (REFERENCE_PATTERN.accepts((Object)expression) && (hasUnresolvedPathVariables = this.resolvePathVariables(pathVarReferences = MVCPathVariableReferenceProvider.createMVCPathVariableReferencesForReferenceExpression(expression)))) {
                    holder.registerProblem((PsiElement)expression, "Expression has unresolved @PathVariable", new LocalQuickFix[0]);
                }
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                if (MVCPathVariableReference.PATTERN.accepts((Object)expression)) {
                    this.resolvePathVariables(expression.getReferences());
                } else if (MVCRequestMappingReference.PATTERN.accepts((Object)expression)) {
                    PsiReference[] references;
                    for (PsiReference reference : references = expression.getReferences()) {
                        if (!(reference instanceof MVCRequestMappingReference) || reference.resolve() != null) continue;
                        holder.registerProblem(reference);
                        return;
                    }
                }
            }

            private boolean resolvePathVariables(PsiReference[] references) {
                boolean hasUnresolved = false;
                for (PsiReference reference : references) {
                    if (!(reference instanceof MVCPathVariableReference) || ((MVCPathVariableReference)reference).multiResolve(false).length != 0) continue;
                    hasUnresolved = true;
                    if (holder.getFile() != reference.getElement().getContainingFile()) continue;
                    holder.registerProblem(reference);
                }
                return hasUnresolved;
            }
        };
        if (javaElementVisitor == null) {
            MVCPathVariableInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getShortName() {
        if ("MVCPathVariableInspection" == null) {
            MVCPathVariableInspection.$$$reportNull$$$0(3);
        }
        return "MVCPathVariableInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

