/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringMvcUsagesCollector
extends AbstractProjectsUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            SpringMvcUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringMvcUsagesCollector.lambda$getProjectUsages$0(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            SpringMvcUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring MVC");
        if (groupDescriptor == null) {
            SpringMvcUsagesCollector.$$$reportNull$$$0(2);
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(@NotNull Project project, Set usages) {
        if (project == null) {
            SpringMvcUsagesCollector.$$$reportNull$$$0(3);
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)project)) {
            return;
        }
        int mvcModelsCount = 0;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            SpringMVCModel mvcModel;
            Collection webFacets;
            SpringFacet springFacet;
            if (!SpringMvcLibraryUtil.hasSpringMvcLibrary((Module)module) || (springFacet = SpringFacet.getInstance((Module)module)) == null || (webFacets = WebFacet.getInstances((Module)module)).isEmpty() || (mvcModel = SpringMVCModelService.getInstance().getModel((WebFacet)webFacets.iterator().next(), springFacet)) == null) continue;
            ++mvcModelsCount;
            List resolvers = mvcModel.getViewResolvers();
            usages.add(new UsageDescriptor("viewResolvers_" + resolvers.size(), 1));
            for (ViewResolver resolver : resolvers) {
                usages.add(new UsageDescriptor("viewResolver_" + resolver.getID(), 1));
            }
            for (SpringModel springModel : mvcModel.getAllModels()) {
                SpringFileSet fileSet = springModel.getFileSet();
                assert (fileSet != null) : springModel;
                String id = fileSet.getId();
                if (id.startsWith("initializer")) {
                    usages.add(new UsageDescriptor("fileset_initializer", 1));
                    continue;
                }
                if (!id.startsWith("web")) continue;
                usages.add(new UsageDescriptor("fileset_webXml", 1));
            }
        }
        usages.add(new UsageDescriptor("mvcModelsInProject_" + mvcModelsCount, 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/SpringMvcUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/SpringMvcUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

