/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.plugins.stylus.formatter.StylusExpressionBlock;
import org.jetbrains.plugins.stylus.formatter.StylusExpressionStatementBlock;
import org.jetbrains.plugins.stylus.formatter.StylusPropertyBlock;
import org.jetbrains.plugins.stylus.formatter.StylusRootBlock;
import org.jetbrains.plugins.stylus.formatter.StylusRulesetBlock;
import org.jetbrains.plugins.stylus.formatter.StylusSelectorBlock;
import org.jetbrains.plugins.stylus.formatter.StylusTermListBlock;
import org.jetbrains.plugins.stylus.formatter.StylusVariableDeclarationBlock;
import org.jetbrains.plugins.stylus.psi.StylusBlockInvocation;
import org.jetbrains.plugins.stylus.psi.StylusBlockMixinInvocation;
import org.jetbrains.plugins.stylus.psi.StylusCssBlock;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusForCycle;
import org.jetbrains.plugins.stylus.psi.StylusIfStatement;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;
import org.jetbrains.plugins.stylus.psi.impl.StylusExpressionImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusExpressionStatementImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinInvocationImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusReturnStatementImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusScopeStatementImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableDeclarationImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableImpl;

public class StylusFormattingModelBuilder
extends CssFormattingModelBuilder {
    private static final TokenSet CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION_BLOCK, CssElementTypes.CSS_PAGE_BLOCK, CssElementTypes.CSS_VIEWPORT, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_FONTFACE, CssElementTypes.CSS_KEYFRAMES_RULE, StylusElementTypes.DECLARATION_BLOCK, StylusElementTypes.IF_STATEMENT});

    protected CssFormattingModelBuilder.CssFormattingExtension createExtension() {
        return StylusFormattingExtension.INSTANCE;
    }

    protected static class StylusFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        static final StylusFormattingExtension INSTANCE = new StylusFormattingExtension();

        protected StylusFormattingExtension() {
        }

        public boolean isComment(IElementType elementType) {
            return StylusTokenTypes.COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public boolean addSubBlocks(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            if (element instanceof StylusExpressionImpl) {
                result.add((Block)new StylusExpressionBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, this, null, null));
                return true;
            }
            return false;
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            Indent indent;
            PsiElement rulesetListParent;
            IElementType parentElementType;
            PsiElement parent = element.getParent();
            IElementType iElementType = parentElementType = parent != null ? parent.getNode().getElementType() : null;
            if (parent != null && parentElementType == CssElementTypes.CSS_RULESET_LIST && (rulesetListParent = parent.getParent()) != null) {
                parentElementType = rulesetListParent.getNode().getElementType();
            }
            Indent indent2 = indent = CONTAINERS.contains(parentElementType) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (element instanceof StylusVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof StylusVariableDeclarationImpl) {
                if (parent instanceof StylusMixinImpl) {
                    result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                } else {
                    result.add((Block)new StylusVariableDeclarationBlock(element.getNode(), settings, indent, maxPropertyLength, this, -1, null, null));
                }
                return true;
            }
            if (element instanceof StylusMixinImpl) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, indent, maxPropertyLength, this, null));
                return true;
            }
            if (element instanceof StylusMixinInvocationImpl) {
                result.add((Block)this.createPropertyBlock(element.getNode(), settings, indent, maxPropertyLength, this, -1, null, null));
                return true;
            }
            if (element instanceof StylusForCycle || element instanceof StylusIfStatement) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, indent, maxPropertyLength, this, null));
                return true;
            }
            if (element instanceof StylusReturnStatementImpl) {
                result.add((Block)this.createPropertyBlock(element.getNode(), settings, indent, maxPropertyLength, this, -1, null, null));
                return true;
            }
            if (element instanceof StylusExpressionStatementImpl) {
                result.add((Block)new StylusExpressionStatementBlock(element.getNode(), settings, indent, maxPropertyLength, this, -1, null, null));
                return true;
            }
            if (element instanceof StylusScopeStatementImpl) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, indent, maxPropertyLength, this, null));
                return true;
            }
            if (element instanceof StylusBlockInvocation) {
                result.add((Block)this.createPropertyBlock(element.getNode(), settings, Indent.getNormalIndent(), maxPropertyLength, this, -1, null, null));
                return true;
            }
            if (element instanceof StylusBlockMixinInvocation || element instanceof StylusCssBlock) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, indent, maxPropertyLength, this, null));
                return true;
            }
            return super.addSubBlocksOfExtendedLanguage(element, settings, maxPropertyLength, result);
        }

        public boolean addLeaf(CssTokenImpl token) {
            if (token.getText().trim().length() == 0) {
                return true;
            }
            return super.addLeaf(token);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment) {
            return new StylusRulesetBlock(_node, settings, indent, maxPropertyLength, extension, alignment);
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new StylusRootBlock(_node, settings, maxPropertyLength, extension);
        }

        public CssFormattingModelBuilder.CssPropertyBlock createPropertyBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, int nameLength, Alignment alignment, Alignment childAlignment) {
            return new StylusPropertyBlock(_node, settings, indent, maxPropertyLength, extension, nameLength, null, null);
        }

        public CssFormattingModelBuilder.CssSelectorBlock createSelectorBlock(ASTNode node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new StylusSelectorBlock(node, settings, Indent.getNoneIndent(), maxPropertyLength, extension);
        }

        public CssFormattingModelBuilder.CssTermListBlock createTermListBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, int nameLength, Alignment alignment, boolean shouldIndentContent) {
            return new StylusTermListBlock(_node, settings, indent, maxPropertyLength, this, nameLength, alignment);
        }
    }
}

