/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import java.util.HashMap;

public class ProfilingModesExt {
    private static final long ALLOCATION_RECORDING_BIT = 2L;
    private static final long ALLOCATION_RECORDING_SAMPLED_STACKS_BIT = 8192L;
    private static final long ALLOCATION_RECORDING_OBJECT_COUNTING_BIT = 16384L;
    private static final long CPU_PROFILING_BIT = 4L;
    private static final long CPU_TRACING_BIT = 8L;
    private static final long CPU_CALL_COUNTING_BIT = 4096L;
    public static final long MONITORS_BIT = 128L;
    public static final long INTERNAL_ERROR_BIT = 256L;
    public static final long STACK_TELEMETRY = 512L;
    public static final long EXCEPTION_TELEMETRY = 1024L;
    public static final long DEADLOCK_DETECTED = 2048L;
    public static final long TRACING_WILL_START = 32768L;
    public static final long ALLOCATION_RECORDING = 24578L;
    public static final long ALLOCATION_RECORDING_EXACT_STACKS = 2L;
    public static final long ALLOCATION_RECORDING_SAMPLED_STACKS = 8194L;
    public static final long ALLOCATION_RECORDING_OBJECT_COUNTING = 16386L;
    public static final long CPU_PROFILING = 4108L;
    public static final long CPU_SAMPLING = 4L;
    public static final long CPU_TRACING = 12L;
    public static final long CPU_CALL_COUNTING = 4100L;

    public static boolean isStackTelemetry(long status) {
        return (status & 0x200L) != 0L;
    }

    public static boolean isMonitorProfiling(long status) {
        return (status & 0x80L) != 0L;
    }

    public static boolean isExceptionTelemetry(long status) {
        return (status & 0x400L) != 0L;
    }

    public static boolean isAllocationRecording(long status) {
        return (status & 0x6002L) != 0L;
    }

    public static boolean isAllocationRecordingExactStacks(long status) {
        return (status & 0x6002L) == 2L;
    }

    public static boolean isAllocationRecordingSampledStacks(long status) {
        return (status & 0x6002L) == 8194L;
    }

    public static boolean isAllocationRecordingObjectCounting(long status) {
        return (status & 0x6002L) == 16386L;
    }

    public static boolean isCPUProfiling(long status) {
        return (status & 4L) != 0L;
    }

    public static boolean isCPUSampling(long status) {
        return (status & 0x100CL) == 4L;
    }

    public static boolean isCPUTracing(long status) {
        return (status & 0x100CL) == 12L;
    }

    public static boolean isCPUCallCounting(long status) {
        return (status & 0x100CL) == 4100L;
    }

    public static boolean isDeadlockDetected(long status) {
        return (status & 0x800L) != 0L;
    }

    public static boolean isCPUTracingBit(long status) {
        return (status & 8L) != 0L;
    }

    public static boolean isCPUCallCountingBit(long status) {
        return (status & 0x1000L) != 0L;
    }

    public static HashMap<Long, String> getMaskPresentation() {
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(2L, "ALLOCATION_RECORDING_BIT");
        map.put(8192L, "ALLOCATION_RECORDING_SAMPLED_STACKS_BIT");
        map.put(16384L, "ALLOCATION_RECORDING_OBJECT_COUNTING_BIT");
        map.put(4L, "CPU_PROFILING_BIT");
        map.put(8L, "CPU_TRACING_BIT");
        map.put(4096L, "CPU_CALL_COUNTING_BIT");
        map.put(128L, "MONITORS_BIT");
        map.put(256L, "INTERNAL_ERROR_BIT");
        map.put(512L, "STACK_TELEMETRY");
        map.put(1024L, "EXCEPTION_TELEMETRY");
        map.put(2048L, "DEADLOCK_DETECTED");
        map.put(32768L, "TRACING_WILL_START");
        return map;
    }
}

