/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip.protocol.debugger;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.OutMessage;
import org.jetbrains.jsonProtocol.OutMessageKt;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.EvaluateOnCallFrameResult;
import org.jetbrains.wip.protocol.debugger.GetPossibleBreakpointsResult;
import org.jetbrains.wip.protocol.debugger.GetScriptSourceResult;
import org.jetbrains.wip.protocol.debugger.Location;
import org.jetbrains.wip.protocol.debugger.RestartFrameResult;
import org.jetbrains.wip.protocol.debugger.ScriptPosition;
import org.jetbrains.wip.protocol.debugger.SearchInContentResult;
import org.jetbrains.wip.protocol.debugger.SetBreakpointByUrlResult;
import org.jetbrains.wip.protocol.debugger.SetBreakpointResult;
import org.jetbrains.wip.protocol.debugger.SetScriptSourceResult;
import org.jetbrains.wip.protocol.debugger.State;
import org.jetbrains.wip.protocol.debugger.TargetCallFrames;
import org.jetbrains.wip.protocol.runtime.CallArgument;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001aZ\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00012\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u0010\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00012\u0006\u0010\u001c\u001a\u00020\f\u001a\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001f\u001a\u00020\f\u001a\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a0\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00012\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020\u0010\u001a\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.\u001a\"\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\f2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020.\u001a \u00103\u001a\b\u0012\u0004\u0012\u0002040\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u00105\u001a\u0004\u0018\u00010\f\u001aB\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00012\u0006\u00108\u001a\u00020+2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010;\u001a\u00020+2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\f\u001a\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010=\u001a\u00020\u0010\u001a\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010?\u001a\u00020@\u001a&\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u00012\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\b\b\u0002\u0010D\u001a\u00020\u0010\u001a\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010F\u001a\u00020\u0010\u001a,\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010H\u001a\u00020+2\u0006\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020K2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006O"}, d2={"ContinueToLocation", "Lorg/jetbrains/wip/protocol/WipRequest;", "", "location", "Lorg/jetbrains/wip/protocol/debugger/Location;", "targetCallFrames", "Lorg/jetbrains/wip/protocol/debugger/TargetCallFrames;", "Disable", "Enable", "EvaluateOnCallFrame", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "callFrameId", "", "expression", "objectGroup", "includeCommandLineAPI", "", "silent", "returnByValue", "generatePreview", "throwOnSideEffect", "GetPossibleBreakpoints", "Lorg/jetbrains/wip/protocol/debugger/GetPossibleBreakpointsResult;", "start", "end", "restrictToFunction", "GetScriptSource", "Lorg/jetbrains/wip/protocol/debugger/GetScriptSourceResult;", "scriptId", "Pause", "RemoveBreakpoint", "breakpointId", "RestartFrame", "Lorg/jetbrains/wip/protocol/debugger/RestartFrameResult;", "Resume", "ScheduleStepIntoAsync", "SearchInContent", "Lorg/jetbrains/wip/protocol/debugger/SearchInContentResult;", "query", "caseSensitive", "isRegex", "SetAsyncCallStackDepth", "maxDepth", "", "SetBlackboxPatterns", "patterns", "", "", "SetBlackboxedRanges", "positions", "Lorg/jetbrains/wip/protocol/debugger/ScriptPosition;", "SetBreakpoint", "Lorg/jetbrains/wip/protocol/debugger/SetBreakpointResult;", "condition", "SetBreakpointByUrl", "Lorg/jetbrains/wip/protocol/debugger/SetBreakpointByUrlResult;", "lineNumber", "url", "urlRegex", "columnNumber", "SetBreakpointsActive", "active", "SetPauseOnExceptions", "state", "Lorg/jetbrains/wip/protocol/debugger/State;", "SetScriptSource", "Lorg/jetbrains/wip/protocol/debugger/SetScriptSourceResult;", "scriptSource", "dryRun", "SetSkipAllPauses", "skip", "SetVariableValue", "scopeNumber", "variableName", "newValue", "Lorg/jetbrains/wip/protocol/runtime/CallArgument;", "StepInto", "StepOut", "StepOver", "wip-protocol"})
public final class DebuggerKt {
    @NotNull
    public static final WipRequest<Unit> Enable() {
        return new WipRequest<Unit>("Debugger.enable");
    }

    @NotNull
    public static final WipRequest<Unit> Disable() {
        return new WipRequest<Unit>("Debugger.disable");
    }

    @NotNull
    public static final WipRequest<Unit> SetBreakpointsActive(boolean active) {
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setBreakpointsActive");
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"active", (boolean)active);
        return m;
    }

    @NotNull
    public static final WipRequest<Unit> SetSkipAllPauses(boolean skip) {
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setSkipAllPauses");
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"skip", (boolean)skip);
        return m;
    }

    @NotNull
    public static final WipRequest<SetBreakpointByUrlResult> SetBreakpointByUrl(int lineNumber, @Nullable CharSequence url, @Nullable CharSequence urlRegex, int columnNumber, @Nullable CharSequence condition) {
        WipRequest<SetBreakpointByUrlResult> m = new WipRequest<SetBreakpointByUrlResult>("Debugger.setBreakpointByUrl");
        OutMessageKt.writeInt((OutMessage)((OutMessage)m), (String)"lineNumber", (int)lineNumber);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"url", (CharSequence)url, null);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"urlRegex", (CharSequence)urlRegex, null);
        OutMessageKt.writeInt((OutMessage)((OutMessage)m), (String)"columnNumber", (int)columnNumber, (int)-1);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"condition", (CharSequence)condition, null);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest SetBreakpointByUrl$default(int n, CharSequence charSequence, CharSequence charSequence2, int n2, CharSequence charSequence3, int n3, Object object) {
        if ((n3 & 2) != 0) {
            charSequence = null;
        }
        if ((n3 & 4) != 0) {
            charSequence2 = null;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        if ((n3 & 0x10) != 0) {
            charSequence3 = null;
        }
        return DebuggerKt.SetBreakpointByUrl(n, charSequence, charSequence2, n2, charSequence3);
    }

    @NotNull
    public static final WipRequest<SetBreakpointResult> SetBreakpoint(@NotNull Location location, @Nullable CharSequence condition) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)location), (String)"location");
        WipRequest<SetBreakpointResult> m = new WipRequest<SetBreakpointResult>("Debugger.setBreakpoint");
        m.writeMessage("location", location);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"condition", (CharSequence)condition, null);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest SetBreakpoint$default(Location location, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            charSequence = null;
        }
        return DebuggerKt.SetBreakpoint(location, charSequence);
    }

    @NotNull
    public static final WipRequest<Unit> RemoveBreakpoint(@NotNull CharSequence breakpointId) {
        Intrinsics.checkParameterIsNotNull((Object)breakpointId, (String)"breakpointId");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.removeBreakpoint");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"breakpointId", (CharSequence)breakpointId);
        return m;
    }

    @NotNull
    public static final WipRequest<GetPossibleBreakpointsResult> GetPossibleBreakpoints(@NotNull Location start, @Nullable Location end, boolean restrictToFunction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)start), (String)"start");
        WipRequest<GetPossibleBreakpointsResult> m = new WipRequest<GetPossibleBreakpointsResult>("Debugger.getPossibleBreakpoints");
        m.writeMessage("start", start);
        m.writeMessage("end", end);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"restrictToFunction", (boolean)restrictToFunction, (boolean)false);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest GetPossibleBreakpoints$default(Location location, Location location2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            location2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return DebuggerKt.GetPossibleBreakpoints(location, location2, bl);
    }

    @NotNull
    public static final WipRequest<Unit> ContinueToLocation(@NotNull Location location, @Nullable TargetCallFrames targetCallFrames) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)location), (String)"location");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.continueToLocation");
        m.writeMessage("location", location);
        OutMessageKt.writeEnum((OutMessage)((OutMessage)m), (String)"targetCallFrames", (Enum)targetCallFrames, null);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest ContinueToLocation$default(Location location, TargetCallFrames targetCallFrames, int n, Object object) {
        if ((n & 2) != 0) {
            targetCallFrames = null;
        }
        return DebuggerKt.ContinueToLocation(location, targetCallFrames);
    }

    @NotNull
    public static final WipRequest<Unit> StepOver() {
        return new WipRequest<Unit>("Debugger.stepOver");
    }

    @NotNull
    public static final WipRequest<Unit> StepInto() {
        return new WipRequest<Unit>("Debugger.stepInto");
    }

    @NotNull
    public static final WipRequest<Unit> StepOut() {
        return new WipRequest<Unit>("Debugger.stepOut");
    }

    @NotNull
    public static final WipRequest<Unit> Pause() {
        return new WipRequest<Unit>("Debugger.pause");
    }

    @NotNull
    public static final WipRequest<Unit> ScheduleStepIntoAsync() {
        return new WipRequest<Unit>("Debugger.scheduleStepIntoAsync");
    }

    @NotNull
    public static final WipRequest<Unit> Resume() {
        return new WipRequest<Unit>("Debugger.resume");
    }

    @NotNull
    public static final WipRequest<SearchInContentResult> SearchInContent(@NotNull CharSequence scriptId, @NotNull CharSequence query, boolean caseSensitive, boolean isRegex) {
        Intrinsics.checkParameterIsNotNull((Object)scriptId, (String)"scriptId");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        WipRequest<SearchInContentResult> m = new WipRequest<SearchInContentResult>("Debugger.searchInContent");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"scriptId", (CharSequence)scriptId);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"query", (CharSequence)query);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"caseSensitive", (boolean)caseSensitive, (boolean)false);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"isRegex", (boolean)isRegex, (boolean)false);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest SearchInContent$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return DebuggerKt.SearchInContent(charSequence, charSequence2, bl, bl2);
    }

    @NotNull
    public static final WipRequest<SetScriptSourceResult> SetScriptSource(@NotNull CharSequence scriptId, @NotNull CharSequence scriptSource, boolean dryRun) {
        Intrinsics.checkParameterIsNotNull((Object)scriptId, (String)"scriptId");
        Intrinsics.checkParameterIsNotNull((Object)scriptSource, (String)"scriptSource");
        WipRequest<SetScriptSourceResult> m = new WipRequest<SetScriptSourceResult>("Debugger.setScriptSource");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"scriptId", (CharSequence)scriptId);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"scriptSource", (CharSequence)scriptSource);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"dryRun", (boolean)dryRun, (boolean)false);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest SetScriptSource$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DebuggerKt.SetScriptSource(charSequence, charSequence2, bl);
    }

    @NotNull
    public static final WipRequest<RestartFrameResult> RestartFrame(@NotNull CharSequence callFrameId) {
        Intrinsics.checkParameterIsNotNull((Object)callFrameId, (String)"callFrameId");
        WipRequest<RestartFrameResult> m = new WipRequest<RestartFrameResult>("Debugger.restartFrame");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"callFrameId", (CharSequence)callFrameId);
        return m;
    }

    @NotNull
    public static final WipRequest<GetScriptSourceResult> GetScriptSource(@NotNull CharSequence scriptId) {
        Intrinsics.checkParameterIsNotNull((Object)scriptId, (String)"scriptId");
        WipRequest<GetScriptSourceResult> m = new WipRequest<GetScriptSourceResult>("Debugger.getScriptSource");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"scriptId", (CharSequence)scriptId);
        return m;
    }

    @NotNull
    public static final WipRequest<Unit> SetPauseOnExceptions(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setPauseOnExceptions");
        OutMessageKt.writeEnum((OutMessage)((OutMessage)m), (String)"state", (Enum)state);
        return m;
    }

    @NotNull
    public static final WipRequest<EvaluateOnCallFrameResult> EvaluateOnCallFrame(@NotNull CharSequence callFrameId, @NotNull CharSequence expression, @Nullable CharSequence objectGroup, boolean includeCommandLineAPI, boolean silent, boolean returnByValue, boolean generatePreview, boolean throwOnSideEffect) {
        Intrinsics.checkParameterIsNotNull((Object)callFrameId, (String)"callFrameId");
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        WipRequest<EvaluateOnCallFrameResult> m = new WipRequest<EvaluateOnCallFrameResult>("Debugger.evaluateOnCallFrame");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"callFrameId", (CharSequence)callFrameId);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"expression", (CharSequence)expression);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"objectGroup", (CharSequence)objectGroup, null);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"includeCommandLineAPI", (boolean)includeCommandLineAPI, (boolean)false);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"silent", (boolean)silent, (boolean)false);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"returnByValue", (boolean)returnByValue, (boolean)false);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"generatePreview", (boolean)generatePreview, (boolean)false);
        OutMessageKt.writeBoolean((OutMessage)((OutMessage)m), (String)"throwOnSideEffect", (boolean)throwOnSideEffect, (boolean)false);
        return m;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WipRequest EvaluateOnCallFrame$default(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 4) != 0) {
            charSequence3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        if ((n & 0x80) != 0) {
            bl5 = false;
        }
        return DebuggerKt.EvaluateOnCallFrame(charSequence, charSequence2, charSequence3, bl, bl2, bl3, bl4, bl5);
    }

    @NotNull
    public static final WipRequest<Unit> SetVariableValue(int scopeNumber, @NotNull CharSequence variableName, @NotNull CallArgument newValue, @NotNull CharSequence callFrameId) {
        Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)newValue), (String)"newValue");
        Intrinsics.checkParameterIsNotNull((Object)callFrameId, (String)"callFrameId");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setVariableValue");
        OutMessageKt.writeInt((OutMessage)((OutMessage)m), (String)"scopeNumber", (int)scopeNumber);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"variableName", (CharSequence)variableName);
        m.writeMessage("newValue", newValue);
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"callFrameId", (CharSequence)callFrameId);
        return m;
    }

    @NotNull
    public static final WipRequest<Unit> SetAsyncCallStackDepth(int maxDepth) {
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setAsyncCallStackDepth");
        OutMessageKt.writeInt((OutMessage)((OutMessage)m), (String)"maxDepth", (int)maxDepth);
        return m;
    }

    @NotNull
    public static final WipRequest<Unit> SetBlackboxPatterns(@NotNull List<String> patterns) {
        Intrinsics.checkParameterIsNotNull(patterns, (String)"patterns");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setBlackboxPatterns");
        m.writeStringList("patterns", patterns);
        return m;
    }

    @NotNull
    public static final WipRequest<Unit> SetBlackboxedRanges(@NotNull CharSequence scriptId, @NotNull List<ScriptPosition> positions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptId, (String)"scriptId");
        Intrinsics.checkParameterIsNotNull(positions, (String)"positions");
        WipRequest<Unit> m = new WipRequest<Unit>("Debugger.setBlackboxedRanges");
        OutMessageKt.writeString((OutMessage)((OutMessage)m), (String)"scriptId", (CharSequence)scriptId);
        m.writeList("positions", positions);
        return m;
    }
}

