/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.WipWorkerVm;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.target.AttachedToTargetEventData;
import org.jetbrains.wip.protocol.target.DetachedFromTargetEventData;
import org.jetbrains.wip.protocol.target.ReceivedMessageFromTargetEventData;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "workers", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/wip/WipWorkerVm;", "enableWorkerDebugging", "", "worker", "workerCreated", "data", "Lorg/jetbrains/wip/protocol/target/AttachedToTargetEventData;", "parentVm", "workerMessageReceived", "Lorg/jetbrains/wip/protocol/target/ReceivedMessageFromTargetEventData;", "workerTerminated", "Lorg/jetbrains/wip/protocol/target/DetachedFromTargetEventData;", "wip-backend"})
public final class WipWorkerManager {
    private final ConcurrentMap<String, WipWorkerVm> workers;
    private final WipVm vm;

    public final void workerCreated(@NotNull AttachedToTargetEventData data, @NotNull WipVm parentVm) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)parentVm), (String)"parentVm");
        String id = data.targetInfo().targetId();
        WipWorkerVm wipWorkerVm = (WipWorkerVm)((Object)this.workers.remove(id));
        if (wipWorkerVm != null) {
            wipWorkerVm.terminate();
        }
        WipWorkerVm workerVm = new WipWorkerVm(id, data.targetInfo().url(), parentVm);
        this.workers.put(id, workerVm);
        this.enableWorkerDebugging(workerVm);
        this.vm.getChildVMs().add(workerVm);
    }

    private final void enableWorkerDebugging(WipWorkerVm worker) {
        WipVmKt.enableConsole(worker.getCommandProcessor());
        worker.getCommandProcessor().send((Request)DebuggerKt.Enable()).then(new Function<T, SUB_RESULT>(this, worker){
            final /* synthetic */ WipWorkerManager this$0;
            final /* synthetic */ WipWorkerVm $worker;

            public final void fun(Unit it) {
                WipWorkerManager.access$getVm$p(this.this$0).getDebugListener().childVmAdded((Vm)this.$worker);
            }
            {
                this.this$0 = wipWorkerManager;
                this.$worker = wipWorkerVm;
            }
        });
        worker.getCommandProcessor().send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void workerTerminated(@NotNull DetachedFromTargetEventData data) {
        block0: {
            WipWorkerVm wipWorkerVm;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            String id = data.getTargetId();
            WipWorkerVm wipWorkerVm2 = (WipWorkerVm)((Object)this.workers.remove(id));
            if (wipWorkerVm2 == null) break block0;
            WipWorkerVm it = wipWorkerVm = wipWorkerVm2;
            this.vm.getChildVMs().remove((Object)it);
            it.terminate();
        }
    }

    public final void workerMessageReceived(@NotNull ReceivedMessageFromTargetEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String workerId = data.getTargetId();
        Object object = (WipWorkerVm)((Object)this.workers.get(workerId));
        if (object == null || (object = object.getCommandProcessor()) == null) {
            return;
        }
        WipWorkerVm processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)data.message()));
    }

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.workers = ContainerUtil.newConcurrentMap();
    }

    @NotNull
    public static final /* synthetic */ WipVm access$getVm$p(WipWorkerManager $this) {
        return $this.vm;
    }
}

