/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.appengine.build;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.FactoryMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class EnhancerProcessHandlerBase
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.appengine.enhancement.EnhancerProcessHandler");
    private Map<Key, EnhancerOutputParser> myParsers;

    public EnhancerProcessHandlerBase(Process process, @NotNull String commandLine, Charset charset) {
        if (commandLine == null) {
            EnhancerProcessHandlerBase.$$$reportNull$$$0(0);
        }
        super(process, commandLine, charset);
        this.myParsers = FactoryMap.create(key -> new EnhancerOutputParser(ProcessOutputTypes.STDERR.equals(key)));
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    EnhancerProcessHandlerBase.this.reportError("Enhancement process terminated with exit code " + exitCode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jps/appengine/build/EnhancerProcessHandlerBase$1", "processTerminated"));
            }
        });
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            EnhancerProcessHandlerBase.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            EnhancerProcessHandlerBase.$$$reportNull$$$0(2);
        }
        super.notifyTextAvailable(text, outputType);
        this.myParsers.get(outputType).appendText(text);
    }

    protected abstract void reportInfo(String var1);

    protected abstract void reportError(String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/appengine/build/EnhancerProcessHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class EnhancerOutputParser {
        @NonNls
        private static final String PLEASE_SEE_THE_LOGS_PREFIX = "Please see the logs [";
        private StringBuilder myBuffer = new StringBuilder();
        private final boolean myErrorStream;

        public EnhancerOutputParser(boolean errorStream) {
            this.myErrorStream = errorStream;
        }

        public void appendText(String text) {
            this.myBuffer.append(text);
            int start = 0;
            while (true) {
                int lineEnd1 = this.myBuffer.indexOf("\n", start);
                int lineEnd2 = this.myBuffer.indexOf("\r", start);
                if (lineEnd1 == -1 && lineEnd2 == -1) break;
                int lineEnd = lineEnd1 == -1 ? lineEnd2 : (lineEnd2 == -1 ? lineEnd1 : Math.min(lineEnd1, lineEnd2));
                this.parseLine(this.myBuffer.substring(start, lineEnd).trim());
                start = lineEnd + 1;
            }
            this.myBuffer.delete(0, start);
        }

        private void parseLine(String line) {
            LOG.debug(this.myErrorStream ? "[err] " + line : line);
            if (this.myErrorStream) {
                EnhancerProcessHandlerBase.this.reportError(line);
                return;
            }
            if (line.startsWith("Encountered a problem: ")) {
                EnhancerProcessHandlerBase.this.reportError(line);
            } else if (line.startsWith(PLEASE_SEE_THE_LOGS_PREFIX)) {
                if (!this.showLogFileContent(line)) {
                    EnhancerProcessHandlerBase.this.reportError(line);
                }
            } else if (line.startsWith("DataNucleus Enhancer completed")) {
                EnhancerProcessHandlerBase.this.reportInfo(line);
            }
        }

        private boolean showLogFileContent(String line) {
            File logFile;
            int i = line.lastIndexOf(93);
            if (i != -1 && (logFile = new File(line.substring(PLEASE_SEE_THE_LOGS_PREFIX.length(), i))).exists()) {
                try {
                    EnhancerProcessHandlerBase.this.reportError(FileUtil.loadFile((File)logFile));
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

