/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.Environment;
import com.android.tools.analytics.HostData;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DisplayDetails;
import com.google.wireless.android.sdk.stats.GarbageCollectionStats;
import com.google.wireless.android.sdk.stats.JavaProcessStats;
import com.google.wireless.android.sdk.stats.JvmDetails;
import com.google.wireless.android.sdk.stats.MachineDetails;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.sun.management.OperatingSystemMXBean;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonMetricsData {
    public static final String VM_OPTION_XMS = "-Xms";
    public static final String VM_OPTION_XMX = "-Xmx";
    public static final String VM_OPTION_MAX_PERM_SIZE = "-XX:MaxPermSize=";
    public static final String VM_OPTION_RESERVED_CODE_CACHE_SIZE = "-XX:ReservedCodeCacheSize=";
    public static final String VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB = "-XX:SoftRefLRUPolicyMSPerMB=";
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;
    public static final int NO_DIGITS = -1;
    public static final int INVALID_POSTFIX = -2;
    public static final int INVALID_NUMBER = -3;
    public static final int EMPTY_SIZE = -4;
    static final Map<String, GarbageCollectionStatsDiffs> sGarbageCollectionStats = new HashMap<String, GarbageCollectionStatsDiffs>();

    public static ProductDetails.CpuArchitecture getOsArchitecture() {
        ProductDetails.CpuArchitecture jvmArchitecture = CommonMetricsData.getJvmArchitecture();
        if (jvmArchitecture == ProductDetails.CpuArchitecture.X86) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("win")) {
                String w6432 = Environment.getInstance().getVariable("PROCESSOR_ARCHITEW6432");
                if (w6432 != null && w6432.contains("64")) {
                    return ProductDetails.CpuArchitecture.X86_64;
                }
            } else if (os.startsWith("linux")) {
                String s = Environment.getInstance().getVariable("HOSTTYPE");
                return CommonMetricsData.cpuArchitectureFromString(s);
            }
        }
        return jvmArchitecture;
    }

    public static ProductDetails.CpuArchitecture getJvmArchitecture() {
        String arch = System.getProperty("os.arch");
        return CommonMetricsData.cpuArchitectureFromString(arch);
    }

    public static ProductDetails.CpuArchitecture cpuArchitectureFromString(String cpuArchitecture) {
        if (cpuArchitecture == null || cpuArchitecture.length() == 0) {
            return ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
        }
        if (cpuArchitecture.equalsIgnoreCase("x86_64") || cpuArchitecture.equalsIgnoreCase("ia64") || cpuArchitecture.equalsIgnoreCase("amd64")) {
            return ProductDetails.CpuArchitecture.X86_64;
        }
        if (cpuArchitecture.equalsIgnoreCase("x86")) {
            return ProductDetails.CpuArchitecture.X86;
        }
        if (cpuArchitecture.length() == 4 && cpuArchitecture.charAt(0) == 'i' && cpuArchitecture.indexOf("86") == 2) {
            return ProductDetails.CpuArchitecture.X86;
        }
        return ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
    }

    public static String getOsName() {
        String os = System.getProperty("os.name");
        if (os == null || os.length() == 0) {
            return "unknown";
        }
        String osLower = os.toLowerCase(Locale.US);
        if (osLower.startsWith("mac")) {
            os = "macosx";
        } else if (osLower.startsWith("win")) {
            os = "windows";
        } else if (osLower.startsWith("linux")) {
            os = "linux";
        } else if (os.length() > 32) {
            os = os.substring(0, 32);
        }
        return os;
    }

    public static String getMajorOsVersion() {
        Matcher m;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = System.getProperty("os.version");
        if (osVers != null && osVers.length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        return null;
    }

    public static DeviceInfo.ApplicationBinaryInterface applicationBinaryInterfaceFromString(String value) {
        if (value == null) {
            return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (value) {
            case "armeabi-v6j": {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6J;
            }
            case "armeabi-v6l": {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6L;
            }
            case "armeabi-v7a": {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
            }
            case "armeabi": {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
            }
            case "arm64-v8a": {
                return DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
            }
            case "mips": {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
            }
            case "mips-r2": {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
            }
            case "x86": {
                return DeviceInfo.ApplicationBinaryInterface.X86_ABI;
            }
            case "x86_64": {
                return DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
            }
        }
        return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
    }

    public static MachineDetails getMachineDetails(File homePath) {
        OperatingSystemMXBean osBean = HostData.getOsBean();
        return MachineDetails.newBuilder().setAvailableProcessors(osBean.getAvailableProcessors()).setTotalRam(osBean.getTotalPhysicalMemorySize()).setTotalDisk(homePath.getTotalSpace()).addAllDisplay(CommonMetricsData.getDisplayDetails()).build();
    }

    private static Iterable<? extends DisplayDetails> getDisplayDetails() {
        ArrayList<DisplayDetails> displays = new ArrayList<DisplayDetails>();
        GraphicsEnvironment graphics = HostData.getGraphicsEnvironment();
        if (!graphics.isHeadlessInstance()) {
            for (GraphicsDevice device : graphics.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                displays.add(DisplayDetails.newBuilder().setHeight(bounds.height).setWidth(bounds.width).build());
            }
        }
        return displays;
    }

    public static JvmDetails getJvmDetails() {
        RuntimeMXBean runtime = HostData.getRuntimeBean();
        JvmDetails.Builder builder = JvmDetails.newBuilder().setName(Strings.nullToEmpty((String)runtime.getVmName())).setVendor(Strings.nullToEmpty((String)runtime.getVmVendor())).setVersion(Strings.nullToEmpty((String)runtime.getVmVersion()));
        for (String vmOption : runtime.getInputArguments()) {
            CommonMetricsData.parseVmOption(vmOption, builder);
        }
        return builder.build();
    }

    private static void parseVmOption(String vmOption, JvmDetails.Builder builder) {
        if (vmOption.startsWith(VM_OPTION_XMS)) {
            builder.setMinimumHeapSize(CommonMetricsData.parseVmOptionSize(vmOption.substring(VM_OPTION_XMS.length())));
        } else if (vmOption.startsWith(VM_OPTION_XMX)) {
            builder.setMaximumHeapSize(CommonMetricsData.parseVmOptionSize(vmOption.substring(VM_OPTION_XMX.length())));
        } else if (vmOption.startsWith(VM_OPTION_MAX_PERM_SIZE)) {
            builder.setMaximumPermanentSpaceSize(CommonMetricsData.parseVmOptionSize(vmOption.substring(VM_OPTION_MAX_PERM_SIZE.length())));
        } else if (vmOption.startsWith(VM_OPTION_RESERVED_CODE_CACHE_SIZE)) {
            builder.setMaximumCodeCacheSize(CommonMetricsData.parseVmOptionSize(vmOption.substring(VM_OPTION_RESERVED_CODE_CACHE_SIZE.length())));
        } else if (vmOption.startsWith(VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB)) {
            builder.setSoftReferenceLruPolicy(CommonMetricsData.parseVmOptionSize(vmOption.substring(VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB.length())));
        }
        switch (vmOption) {
            case "-XX:+UseConcMarkSweepGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.CONCURRENT_MARK_SWEEP_GC);
                break;
            }
            case "-XX:+UseParallelGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_GC);
                break;
            }
            case "-XX:+UseParallelOldGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_OLD_GC);
                break;
            }
            case "-XX:+UseSerialGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
                break;
            }
            case "-XX:+UseG1GC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
            }
        }
    }

    static long parseVmOptionSize(String vmOptionSize) {
        if (Strings.isNullOrEmpty((String)vmOptionSize)) {
            return -4L;
        }
        try {
            for (int i = 0; i < vmOptionSize.length(); ++i) {
                char c = vmOptionSize.charAt(i);
                if (Character.isDigit(c)) continue;
                if (i == 0) {
                    return -1L;
                }
                String digits = vmOptionSize.substring(0, i);
                long value = Long.parseLong(digits);
                switch (c) {
                    case 'T': 
                    case 't': {
                        return value * 0x10000000000L;
                    }
                    case 'G': 
                    case 'g': {
                        return value * 0x40000000L;
                    }
                    case 'M': 
                    case 'm': {
                        return value * 0x100000L;
                    }
                    case 'K': 
                    case 'k': {
                        return value * 1024L;
                    }
                }
                return -2L;
            }
            return Long.parseLong(vmOptionSize);
        }
        catch (NumberFormatException e) {
            return -3L;
        }
    }

    public static JavaProcessStats getJavaProcessStats() {
        MemoryMXBean memoryBean = HostData.getMemoryBean();
        ClassLoadingMXBean classLoadingBean = HostData.getClassLoadingBean();
        return JavaProcessStats.newBuilder().setHeapMemoryUsage(memoryBean.getHeapMemoryUsage().getUsed()).setNonHeapMemoryUsage(memoryBean.getNonHeapMemoryUsage().getUsed()).setLoadedClassCount(classLoadingBean.getLoadedClassCount()).addAllGarbageCollectionStats(CommonMetricsData.getGarbageCollectionStats()).setThreadCount(HostData.getThreadBean().getThreadCount()).build();
    }

    static List<GarbageCollectionStats> getGarbageCollectionStats() {
        ArrayList<GarbageCollectionStats> stats = new ArrayList<GarbageCollectionStats>();
        for (GarbageCollectorMXBean gc : HostData.getGarbageCollectorBeans()) {
            String name = gc.getName();
            GarbageCollectionStatsDiffs previous = sGarbageCollectionStats.get(name);
            if (previous == null) {
                previous = new GarbageCollectionStatsDiffs();
            }
            GarbageCollectionStatsDiffs current = new GarbageCollectionStatsDiffs();
            current.collections = gc.getCollectionCount();
            long collectionsDiff = current.collections - previous.collections;
            current.time = gc.getCollectionTime();
            long timeDiff = current.time - previous.time;
            sGarbageCollectionStats.put(name, current);
            stats.add(GarbageCollectionStats.newBuilder().setName(gc.getName()).setGcCollections(collectionsDiff).setGcTime(timeDiff).build());
        }
        return stats;
    }

    static class GarbageCollectionStatsDiffs {
        volatile long collections;
        volatile long time;

        GarbageCollectionStatsDiffs() {
        }
    }
}

