/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.psi.AopElementType;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPointcutDesignatorTokenType;
import com.intellij.aop.psi.AopPointcutElementType;
import com.intellij.aop.psi.AopPrattParser;
import com.intellij.aop.psi.AopPrattRegistry;
import com.intellij.aop.psi.FieldPatternPointcut;
import com.intellij.aop.psi.FieldPointcutDescriptor;
import com.intellij.aop.psi.MethodPointcutDescriptor;
import com.intellij.aop.psi.PointcutDescriptor;
import com.intellij.aop.psi.PsiAdviceExecutionExpression;
import com.intellij.aop.psi.PsiArgsExpression;
import com.intellij.aop.psi.PsiAtAnnotationExpression;
import com.intellij.aop.psi.PsiAtArgsExpression;
import com.intellij.aop.psi.PsiAtTargetExpression;
import com.intellij.aop.psi.PsiAtThisExpression;
import com.intellij.aop.psi.PsiAtWithinExpression;
import com.intellij.aop.psi.PsiCallExpression;
import com.intellij.aop.psi.PsiControlFlowPointcutExpression;
import com.intellij.aop.psi.PsiExecutionExpression;
import com.intellij.aop.psi.PsiHandlerPointcutExpression;
import com.intellij.aop.psi.PsiIfPointcutExpression;
import com.intellij.aop.psi.PsiInitializationPointcutExpression;
import com.intellij.aop.psi.PsiMonitorPointcutExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiStaticInitializationExpression;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.aop.psi.PsiThisExpression;
import com.intellij.aop.psi.PsiWithinCodePointcutExpression;
import com.intellij.aop.psi.PsiWithinExpression;
import com.intellij.lang.ASTNode;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PathPattern;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.ReducingParser;
import com.intellij.lang.pratt.TokenParser;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class AopPointcutTypes {
    private static final Map<String, AopElementType> ourPointcutTokens = new THashMap();
    private static final Map<String, PointcutDescriptor> ourPointcutDescriptors = new THashMap();

    public static Map<String, AopElementType> getPointcutTokens() {
        return ourPointcutTokens;
    }

    public static boolean canContainModifiers(String tokenText) {
        PointcutDescriptor descriptor = ourPointcutDescriptors.get(tokenText);
        return descriptor instanceof MethodPointcutDescriptor || descriptor instanceof FieldPointcutDescriptor;
    }

    private static void parseTypePatternPointcut(PrattBuilder builder, int level, String message) {
        if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
            MutableMarker type = builder.mark();
            builder.parseChildren(level, message);
            type.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
            builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
        }
    }

    public static void parseFormalParameterList(PrattBuilder builder) {
        AopPointcutTypes.parseParameterList(builder, () -> {
            MutableMarker begin = builder.mark();
            if (builder.getTokenType() == AopElementTypes.AOP_NOT || builder.getTokenType() == AopElementTypes.AOP_AT) {
                AopPrattParser.parseAnnotations(builder);
                if (builder.getTokenType() == AopElementTypes.AOP_LEFT_PAR) {
                    begin.drop();
                    builder.advance();
                    MutableMarker holder = builder.mark();
                    builder.parseChildren(70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
                    holder.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                    builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                    return;
                }
            }
            begin.rollback();
            MutableMarker holder = builder.mark();
            builder.parseChildren(70, AopBundle.message("error.method.args.pattern.expected", new Object[0]));
            holder.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
        });
    }

    private static void parseParameterList(PrattBuilder builder, Runnable member) {
        MutableMarker paramList = builder.mark();
        if (!builder.isToken((IElementType)AopElementTypes.AOP_RIGHT_PAR)) {
            boolean allowDotDot = true;
            do {
                if (allowDotDot && builder.checkToken((IElementType)AopElementTypes.AOP_DOT_DOT)) {
                    allowDotDot = false;
                    continue;
                }
                member.run();
                allowDotDot = true;
            } while (builder.checkToken((IElementType)AopElementTypes.AOP_COMMA));
        }
        paramList.finish((IElementType)AopElementTypes.AOP_PARAMETER_LIST);
    }

    private static void registerPointcut(final PointcutDescriptor descriptor) {
        String token = descriptor.getTokenText();
        String typeName = "AOP_" + (token.startsWith("@") ? "AT_" + token.substring(1).toUpperCase() : token.toUpperCase());
        AopPointcutDesignatorTokenType tokenType = new AopPointcutDesignatorTokenType(typeName);
        ourPointcutTokens.put(token, tokenType);
        ourPointcutDescriptors.put(token, descriptor);
        final AopPointcutElementType directiveType = new AopPointcutElementType(typeName + "_POINTCUT"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return descriptor.createPsi(node);
            }
        };
        AopPrattRegistry.registerParser(tokenType, 40, PathPattern.path().up(), (TokenParser)new ReducingParser(){

            public IElementType parseFurther(PrattBuilder builder) {
                descriptor.parseToken(builder);
                return directiveType;
            }
        });
    }

    private AopPointcutTypes() {
    }

    static {
        AopPointcutTypes.registerPointcut(new MethodPointcutDescriptor("execution", false){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiExecutionExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new MethodPointcutDescriptor("call", false){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiCallExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new MethodPointcutDescriptor("withincode", false){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiWithinCodePointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new MethodPointcutDescriptor("initialization", true){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiInitializationPointcutExpression(node, false);
            }
        });
        AopPointcutTypes.registerPointcut(new MethodPointcutDescriptor("preinitialization", true){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiInitializationPointcutExpression(node, true);
            }
        });
        AopPointcutTypes.registerPointcut(new FieldPointcutDescriptor("get"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new FieldPatternPointcut(node);
            }
        });
        AopPointcutTypes.registerPointcut(new FieldPointcutDescriptor("set"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new FieldPatternPointcut(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("args"){

            @Override
            public void parseToken(PrattBuilder builder) {
                if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
                    AopPointcutTypes.parseFormalParameterList(builder);
                    builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                }
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiArgsExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("@args"){

            @Override
            public void parseToken(PrattBuilder builder) {
                if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
                    AopPointcutTypes.parseParameterList(builder, () -> {
                        MutableMarker param = builder.mark();
                        builder.parseChildren(90, AopBundle.message("error.method.annotation.name.expected", new Object[0]));
                        param.finish((IElementType)AopElementTypes.AOP_REFERENCE_HOLDER);
                    });
                    builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                }
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAtArgsExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new TypePatternPointcutDescriptor("within"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiWithinExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new TypePatternPointcutDescriptor("this"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiThisExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new TypePatternPointcutDescriptor("target"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiTargetExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new TypePatternPointcutDescriptor("handler"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiHandlerPointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new TypePatternPointcutDescriptor("staticinitialization"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiStaticInitializationExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new AnnoPatternPointcutDescriptor("@this"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAtThisExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new AnnoPatternPointcutDescriptor("@target"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAtTargetExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new AnnoPatternPointcutDescriptor("@within"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAtWithinExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new AnnoPatternPointcutDescriptor("@annotation"){

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAtAnnotationExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("adviceexecution"){

            @Override
            public void parseToken(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiAdviceExecutionExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("lock"){

            @Override
            public void parseToken(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiMonitorPointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("unlock"){

            @Override
            public void parseToken(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiMonitorPointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("cflow"){

            @Override
            public void parseToken(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("));
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(0));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiControlFlowPointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("cflowbelow"){

            @Override
            public void parseToken(PrattBuilder builder) {
                builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("));
                AopPrattParser.parsePointcut(builder, builder.createChildBuilder(0));
                builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiControlFlowPointcutExpression(node);
            }
        });
        AopPointcutTypes.registerPointcut(new PointcutDescriptor("if"){

            @Override
            public void parseToken(PrattBuilder builder) {
                if (builder.assertToken((IElementType)AopElementTypes.AOP_LEFT_PAR, AopBundle.message("error.0.expected", "("))) {
                    builder.checkToken((IElementType)AopElementTypes.AOP_BOOLEAN_LITERAL);
                    builder.assertToken((IElementType)AopElementTypes.AOP_RIGHT_PAR, AopBundle.message("error.0.expected", ")"));
                }
            }

            @Override
            public PsiPointcutExpression createPsi(ASTNode node) {
                return new PsiIfPointcutExpression(node);
            }
        });
        for (PointcutDescriptor descriptor : (PointcutDescriptor[])Extensions.getExtensions(PointcutDescriptor.EP_NAME)) {
            AopPointcutTypes.registerPointcut(descriptor);
        }
    }

    private static abstract class AnnoPatternPointcutDescriptor
    extends PointcutDescriptor {
        protected AnnoPatternPointcutDescriptor(@NonNls String tokenText) {
            super(tokenText);
        }

        @Override
        public void parseToken(PrattBuilder builder) {
            AopPointcutTypes.parseTypePatternPointcut(builder, 90, AopBundle.message("error.method.annotation.name.expected", new Object[0]));
        }
    }

    private static abstract class TypePatternPointcutDescriptor
    extends PointcutDescriptor {
        protected TypePatternPointcutDescriptor(@NonNls String tokenText) {
            super(tokenText);
        }

        @Override
        public void parseToken(PrattBuilder builder) {
            AopPointcutTypes.parseTypePatternPointcut(builder, 70, AopBundle.message("error.type.name.pattern.expected", new Object[0]));
        }
    }
}

