/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.aop.psi.PsiIfPointcutExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PointcutMethodStyleInspection
extends AbstractAopInspection {
    @Override
    protected void checkAopMethod(PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator == null || manipulator.getAdviceType() != null) {
            return;
        }
        PsiElement problemElement = manipulator.getCommonProblemElement();
        if (!PsiType.VOID.equals((Object)pointcutMethod.getReturnType())) {
            PsiPointcutExpression expression = aopFile.getPointcutExpression();
            if (expression instanceof PsiIfPointcutExpression && PsiType.BOOLEAN.equals((Object)pointcutMethod.getReturnType())) {
                return;
            }
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.void.return.type", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        if (pointcutMethod.getThrowsList().getTextLength() > 0) {
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.no.throws.clause", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        PsiCodeBlock body = pointcutMethod.getBody();
        if (body != null && body.getStatements().length > 0) {
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.empty.body", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AopBundle.message("pointcut.method.style.inspection", new Object[0]);
        if (string == null) {
            PointcutMethodStyleInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("PointcutMethodStyleInspection" == null) {
            PointcutMethodStyleInspection.$$$reportNull$$$0(1);
        }
        return "PointcutMethodStyleInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/aop/jam/PointcutMethodStyleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

