/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdviceType;
import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractArgNamesInspection;
import com.intellij.aop.jam.SetArgNamesQuickFix;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.PsiArgsExpression;
import com.intellij.aop.psi.PsiAtPointcutDesignator;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArgNamesWarningsInspection
extends AbstractArgNamesInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            ArgNamesWarningsInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkAnnotation(PsiParameter[] parameters, ProblemsHolder holder, ArgNamesManipulator manipulator, PsiMethod method) {
        if (manipulator.getArgNames() == null && !ArgNamesWarningsInspection.canInferParameters(parameters, manipulator, method)) {
            holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("warning.argNames.should.be.defined", manipulator.getArgNamesAttributeName()), new LocalQuickFix[]{new SetArgNamesQuickFix(AopBundle.message("quickfix.name.define.attribute", manipulator.getArgNamesAttributeName()), true, manipulator, method)});
            return;
        }
        AopAdviceType adviceType = manipulator.getAdviceType();
        if (parameters.length > 0 && adviceType != null && adviceType != AopAdviceType.AROUND && parameters[0].getType().equalsToText("org.aspectj.lang.ProceedingJoinPoint")) {
            holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("error.pjp.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean canInferParameters(PsiParameter[] parameters, ArgNamesManipulator manipulator, PsiMethod method) {
        List primitives;
        if (parameters.length == 0) {
            return true;
        }
        THashSet set = ContainerUtil.newTroveSet((Object[])parameters);
        if (LocalAopModel.isJoinPointParameter(parameters[0])) {
            set.remove(parameters[0]);
            if (set.isEmpty()) {
                return true;
            }
        }
        if (manipulator.getThrowingReference() != null && ArgNamesWarningsInspection.containsOnlyOneParameter(method, (Set<PsiParameter>)set, "java.lang.Throwable")) {
            return true;
        }
        Class<PsiAtPointcutDesignator> designatorClass = PsiAtPointcutDesignator.class;
        List<PsiParameter> shouldBeAnnos = ArgNamesWarningsInspection.findParametersUsedInPointcuts((Set<PsiParameter>)set, designatorClass);
        if (shouldBeAnnos.size() == 1 && ArgNamesWarningsInspection.containsOnlyOneParameter(method, (Set<PsiParameter>)set, "java.lang.annotation.Annotation")) {
            return true;
        }
        if (manipulator.getReturningReference() != null) {
            return set.size() == 1;
        }
        List<PsiParameter> canBePrimitive = ArgNamesWarningsInspection.findParametersUsedInPointcuts((Set<PsiParameter>)set, PsiArgsExpression.class);
        if (canBePrimitive.size() == 1 && (primitives = ContainerUtil.findAll((Collection)set, psiParameter -> psiParameter.getType() instanceof PsiPrimitiveType)).size() == 1) {
            set.removeAll(primitives);
            if (set.isEmpty()) {
                return true;
            }
        }
        if (set.size() == 1) {
            if (canBePrimitive.size() == 1) {
                return true;
            }
            if (ArgNamesWarningsInspection.findParametersUsedInPointcuts((Set<PsiParameter>)set, PsiThisExpression.class).size() == 1) {
                return true;
            }
            if (ArgNamesWarningsInspection.findParametersUsedInPointcuts((Set<PsiParameter>)set, PsiTargetExpression.class).size() == 1) {
                return true;
            }
        }
        return false;
    }

    private static List<PsiParameter> findParametersUsedInPointcuts(Set<PsiParameter> set, Class<?> designatorClass) {
        return ContainerUtil.findAll(set, psiParameter -> !ReferencesSearch.search((PsiElement)psiParameter).forEach(reference -> !(reference instanceof AopReferenceExpression) || !designatorClass.isInstance(PsiTreeUtil.getParentOfType((PsiElement)((AopReferenceExpression)reference), PsiPointcutExpression.class))));
    }

    private static boolean containsOnlyOneParameter(PsiMethod method, Set<PsiParameter> set, String className) {
        PsiClassType baseType = JavaPsiFacade.getInstance((Project)method.getManager().getProject()).getElementFactory().createTypeByFQClassName(className, method.getResolveScope());
        List instanceofs = ContainerUtil.findAll(set, psiParameter -> baseType.isAssignableFrom(psiParameter.getType()));
        if (instanceofs.size() == 1) {
            set.removeAll(instanceofs);
            if (set.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AopBundle.message("inspection.display.name.argNames.warnings", new Object[0]);
        if (string == null) {
            ArgNamesWarningsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ArgNamesWarningsInspection" == null) {
            ArgNamesWarningsInspection.$$$reportNull$$$0(2);
        }
        return "ArgNamesWarningsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/aop/jam/ArgNamesWarningsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

