/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public abstract class AopAdvisedElementsSearcher {
    private final PsiManager myManager;

    protected AopAdvisedElementsSearcher(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public abstract LinkedHashSet<PsiClass> collectAdvisedClasses();

    public boolean shouldSuppressErrors() {
        return false;
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            AopAdvisedElementsSearcher.$$$reportNull$$$0(0);
        }
        return !method.isConstructor() && !method.hasModifierProperty("abstract");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        if (method == null) {
            AopAdvisedElementsSearcher.$$$reportNull$$$0(1);
        }
        return true;
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AopAdvisedElementsSearcher.$$$reportNull$$$0(2);
        }
        return AopAdvisedElementsSearcher.isAspectjAdvisable(psiClass);
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AopAdvisedElementsSearcher.$$$reportNull$$$0(3);
        }
        return false;
    }

    protected static boolean isAspectjAdvisable(PsiClass psiClass) {
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        return modifierList == null || modifierList.findAnnotation("org.aspectj.lang.annotation.Aspect") == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/aop/AopAdvisedElementsSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeAdvised";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsBoundMethodHeavy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInherentlyAdvisable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAdvisableInModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

