/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.ClassNode;
import com.intellij.tapestry.intellij.view.nodes.ComponentNode;
import com.intellij.tapestry.intellij.view.nodes.ComponentsNode;
import com.intellij.tapestry.intellij.view.nodes.FileNode;
import com.intellij.tapestry.intellij.view.nodes.LibraryNode;
import com.intellij.tapestry.intellij.view.nodes.MixinNode;
import com.intellij.tapestry.intellij.view.nodes.MixinsNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNodesComparator;
import com.intellij.tapestry.intellij.view.nodes.PageNode;
import com.intellij.tapestry.intellij.view.nodes.PagesNode;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class PackageNode
extends TapestryNode {
    private Library _library;

    public PackageNode(Library library, PsiDirectory psiDirectory, Module module, AbstractTreeBuilder treeBuilder) {
        super(module, treeBuilder);
        this._library = library;
        this.init(psiDirectory, (ItemPresentation)new PresentationData(psiDirectory.getName(), psiDirectory.getName(), PlatformIcons.PACKAGE_ICON, null));
    }

    public PackageNode(PsiDirectory psiDirectory, Module module, AbstractTreeBuilder treeBuilder) {
        this(null, psiDirectory, module, treeBuilder);
    }

    @Override
    public SimpleNode[] getChildren() {
        TreeSet<TapestryNode> children = new TreeSet<TapestryNode>(PackageNodesComparator.getInstance());
        for (PsiDirectory psiDirectory : ((PsiDirectory)this.getElement()).getSubdirectories()) {
            PackageNode node = this.createNewNode(psiDirectory);
            if (node == null) continue;
            children.add(this.createNewNode(psiDirectory));
        }
        for (PsiDirectory psiDirectory : ((PsiDirectory)this.getElement()).getFiles()) {
            if (psiDirectory instanceof PsiClassOwner) {
                try {
                    if (IdeaUtils.findPublicClass((PsiFile)psiDirectory) == null || !TapestryProjectViewPane.getInstance(this.myProject).isGroupElementFiles()) {
                        throw new NotTapestryElementException("");
                    }
                    PresentationLibraryElement element = this._library == null ? PresentationLibraryElement.createProjectElementInstance((IJavaClassType)IdeaUtils.createJavaTypeFromPsiType(this._module, (PsiType)JavaPsiFacade.getInstance((Project)this._module.getProject()).getElementFactory().createType(IdeaUtils.findPublicClass((PsiFile)psiDirectory))), TapestryModuleSupportLoader.getTapestryProject(this._module)) : PresentationLibraryElement.createElementInstance(this._library, new IntellijJavaClassType(this.getModule(), IdeaUtils.findPublicClass((PsiFile)psiDirectory).getContainingFile()), TapestryModuleSupportLoader.getTapestryProject(this._module));
                    switch (element.getElementType()) {
                        case PAGE: {
                            children.add(new PageNode(element, this._module, this._treeBuilder));
                            break;
                        }
                        case COMPONENT: {
                            children.add(new ComponentNode(element, this._module, this._treeBuilder));
                            break;
                        }
                        case MIXIN: {
                            children.add(new MixinNode(element, this._module, this._treeBuilder));
                        }
                    }
                }
                catch (NotTapestryElementException e) {
                    children.add(new ClassNode((PsiClassOwner)psiDirectory, this._module, this._treeBuilder));
                }
            }
            if (psiDirectory.getFileType().equals((Object)TmlFileType.INSTANCE) && !TapestryProjectViewPane.getInstance(this.myProject).isGroupElementFiles()) {
                children.add(new FileNode((PsiFile)psiDirectory, this._module, this._treeBuilder));
            }
            if (!psiDirectory.getFileType().equals(StdFileTypes.PROPERTIES) || TapestryProjectViewPane.getInstance(this.myProject).isGroupElementFiles()) continue;
            children.add(new FileNode((PsiFile)psiDirectory, this._module, this._treeBuilder));
        }
        return children.toArray(new TapestryNode[children.size()]);
    }

    @Nullable
    private PackageNode createNewNode(PsiDirectory psiDirectory) {
        PsiPackage aPackage = IdeaUtils.getPackage((PsiElement)psiDirectory);
        if (aPackage == null) {
            return null;
        }
        TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(this._module);
        if (tapestryProject == null) {
            return null;
        }
        String applicationRootPackage = tapestryProject.getApplicationRootPackage();
        String packageName = aPackage.getQualifiedName();
        if (packageName.equals(applicationRootPackage)) {
            return new LibraryNode(tapestryProject.getApplicationLibrary(), psiDirectory, this._module, this._treeBuilder);
        }
        if (packageName.equals(tapestryProject.getPagesRootPackage())) {
            return new PagesNode(psiDirectory, this._module, this._treeBuilder);
        }
        if (packageName.equals(tapestryProject.getComponentsRootPackage())) {
            return new ComponentsNode(psiDirectory, this._module, this._treeBuilder);
        }
        if (packageName.equals(tapestryProject.getMixinsRootPackage())) {
            return new MixinsNode(psiDirectory, this._module, this._treeBuilder);
        }
        return new PackageNode(psiDirectory, this._module, this._treeBuilder);
    }
}

