/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryPropertyNamingUtil {
    private TapestryPropertyNamingUtil() {
    }

    public static boolean isWaitOrNotifyOfObject(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(0);
        }
        if ((psiClass = method.getContainingClass()) == null || !"java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        String name = method.getName();
        return "wait".equals(name) || "notify".equals(name) || "notifyAll".equals(name);
    }

    public static boolean isPropertyGetter(@NotNull PsiMethod method) {
        if (method == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(1);
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
                return false;
            }
        } else if (methodName.startsWith("is")) {
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                return false;
            }
        } else {
            return false;
        }
        return method.getParameterList().getParametersCount() == 0;
    }

    public static boolean isPropertySetter(@NotNull PsiMethod method) {
        if (method == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(2);
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > "set".length() && method.getParameterList().getParametersCount() == 1 && (method.getReturnType() == null || PsiType.VOID.equals((Object)method.getReturnType()));
    }

    public static boolean isPropertyAccessor(PsiMethod method) {
        return TapestryPropertyNamingUtil.isPropertyGetter(method) || TapestryPropertyNamingUtil.isPropertySetter(method);
    }

    @Nullable
    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor) {
        if (accessor == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(3);
        }
        if (TapestryPropertyNamingUtil.isPropertySetter(accessor)) {
            return TapestryPropertyNamingUtil.getPropertyNameFromSetter(accessor);
        }
        if (TapestryPropertyNamingUtil.isPropertyGetter(accessor)) {
            return TapestryPropertyNamingUtil.getPropertyNameFromGetter(accessor);
        }
        return null;
    }

    private static String getPropertyNameFromGetter(@NotNull PsiMethod getter) {
        String methodName;
        if (getter == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(4);
        }
        int prefixLength = (methodName = getter.getName()).startsWith("get") ? "get".length() : "is".length();
        return methodName.substring(prefixLength);
    }

    private static String getPropertyNameFromSetter(@NotNull PsiMethod setter) {
        if (setter == null) {
            TapestryPropertyNamingUtil.$$$reportNull$$$0(5);
        }
        return setter.getName().substring("set".length());
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName) {
        return TapestryPropertyNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                return TapestryPropertyNamingUtil.isPropertyGetter(method) ? TapestryPropertyNamingUtil.getPropertyNameFromGetter(method) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil$1", "extractPropertyName"));
            }
        });
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName) {
        return TapestryPropertyNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(0);
                }
                return TapestryPropertyNamingUtil.isPropertySetter(method) ? TapestryPropertyNamingUtil.getPropertyNameFromSetter(method) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil$2", "extractPropertyName"));
            }
        });
    }

    @Nullable
    private static PsiMethod findPropertyAccessor(PsiClass aClass, String propertyName, PropertyNameExtractor extractor) {
        if (aClass == null) {
            return null;
        }
        for (PsiMethod method : aClass.getAllMethods()) {
            String wouldBePropertyName = extractor.extractPropertyName(method);
            if (!propertyName.equalsIgnoreCase(wouldBePropertyName)) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWaitOrNotifyOfObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyGetter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertySetter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromGetter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromSetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface PropertyNameExtractor {
        @Nullable
        public String extractPropertyName(@NotNull PsiMethod var1);
    }
}

