/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.tapestry.TapestryBundle;
import com.intellij.tapestry.intellij.inspections.TapestryInspectionBase;
import com.intellij.tapestry.psi.TelQualifiedReference;
import com.intellij.tapestry.psi.TelReferenceExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TelReferencesInspection
extends TapestryInspectionBase {
    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        boolean resolvedWithError;
        if (!(element instanceof TelReferenceExpression)) {
            return;
        }
        TelQualifiedReference ref = ((TelReferenceExpression)element).getReference();
        if (!ref.isQualifierResolved()) {
            return;
        }
        ResolveResult[] results = ref.multiResolve(false);
        boolean bl = resolvedWithError = results.length > 0 && !results[0].isValidResult();
        if (resolvedWithError || results.length == 0) {
            String message = ref.getUnresolvedMessage(resolvedWithError);
            holder.registerProblem((PsiReference)ref, message, resolvedWithError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = TapestryBundle.message("tel.references.inspection", new Object[0]);
        if (string == null) {
            TelReferencesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("TelReferencesInspection" == null) {
            TelReferencesInspection.$$$reportNull$$$0(1);
        }
        return "TelReferencesInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tapestry/intellij/inspections/TelReferencesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

