/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.resource;

import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.core.resource.IResourceFinder;
import com.intellij.tapestry.core.util.LocalizationUtils;
import com.intellij.tapestry.core.util.PathUtils;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijResourceFinder
implements IResourceFinder {
    private Module _module;

    public IntellijResourceFinder(Module module) {
        this._module = module;
    }

    @Override
    public Collection<IResource> findClasspathResource(String path, boolean includeDependencies) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String filename = PathUtils.getLastPathElement(path);
        for (PsiDirectory directory : this.findPackageDirectories(path, includeDependencies)) {
            PsiFile resource = directory.findFile(filename);
            if (resource == null) continue;
            resources.add(new IntellijResource(resource));
        }
        return resources;
    }

    private PsiDirectory[] findPackageDirectories(String path, boolean includeDependencies) {
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this._module.getProject()).findPackage(PathUtils.pathIntoPackage(path, true));
        return psiPackage == null ? PsiDirectory.EMPTY_ARRAY : psiPackage.getDirectories(this.getSearchScope(includeDependencies));
    }

    @Override
    public Collection<IResource> findLocalizedClasspathResource(String path, boolean includeDependencies) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String filename = PathUtils.getLastPathElement(path);
        for (PsiDirectory directory : this.findPackageDirectories(path, includeDependencies)) {
            for (PsiFile file : directory.getFiles()) {
                if (!LocalizationUtils.unlocalizeFileName(file.getName()).equals(filename)) continue;
                resources.add(new IntellijResource(file));
            }
        }
        return resources;
    }

    private GlobalSearchScope getSearchScope(boolean includeDependencies) {
        if (includeDependencies) {
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this._module, (boolean)false);
        }
        return GlobalSearchScope.moduleScope((Module)this._module);
    }

    @Override
    @Nullable
    public IResource findContextResource(String path) {
        WebFacet webFacet = IdeaUtils.getWebFacet(this._module);
        if (webFacet == null) {
            return null;
        }
        List webRoots = webFacet.getWebRoots();
        for (WebRoot webRoot : webRoots) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            VirtualFile file;
            String relativePath = path;
            if (PathUtils.toUnixPath(path).startsWith(webRoot.getRelativePath())) {
                relativePath = PathUtils.toUnixPath(path).substring(webRoot.getRelativePath().length() + (webRoot.getRelativePath().endsWith("/") ? 0 : 1));
            }
            if ((file = webRoot.getFile()) == null || (virtualFile = file.findFileByRelativePath(relativePath)) == null || (psiFile = PsiManager.getInstance((Project)this._module.getProject()).findFile(virtualFile)) == null) continue;
            return new IntellijResource(psiFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<IResource> findLocalizedContextResource(String path) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        WebFacet webFacet = IdeaUtils.getWebFacet(this._module);
        if (webFacet == null) {
            ArrayList<IResource> arrayList = resources;
            if (arrayList == null) {
                IntellijResourceFinder.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        List webRoots = webFacet.getWebRoots();
        String filename = PathUtils.getLastPathElement(path);
        for (WebRoot webRoot : webRoots) {
            String relativePath = path;
            if (PathUtils.toUnixPath(path).startsWith(webRoot.getRelativePath())) {
                relativePath = PathUtils.toUnixPath(path).substring(webRoot.getRelativePath().length() + (webRoot.getRelativePath().endsWith("/") ? 0 : 1));
            }
            String parentPath = PathUtils.removeLastFilePathElement(relativePath, true);
            VirtualFile virtualFile = webRoot.getFile();
            VirtualFile parentVirtualFile = parentPath.length() > 0 && virtualFile != null ? virtualFile.findFileByRelativePath(parentPath) : virtualFile;
            if (parentVirtualFile == null) continue;
            for (VirtualFile file : parentVirtualFile.getChildren()) {
                PsiFile psiFile;
                if (!LocalizationUtils.unlocalizeFileName(file.getName()).equals(filename) || (psiFile = PsiManager.getInstance((Project)this._module.getProject()).findFile(file)) == null) continue;
                resources.add(new IntellijResource(psiFile));
            }
        }
        ArrayList<IResource> arrayList = resources;
        if (arrayList == null) {
            IntellijResourceFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/core/resource/IntellijResourceFinder", "findLocalizedContextResource"));
    }
}

