/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.components.DummyTapestryParameter;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterReceiverElement
extends PresentationLibraryElement {
    private Map<String, TapestryParameter> _parametersCache;
    private long _parametersCacheTimestamp;

    ParameterReceiverElement(@Nullable Library library, @NotNull IJavaClassType elementClass, @NotNull TapestryProject project) {
        if (elementClass == null) {
            ParameterReceiverElement.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ParameterReceiverElement.$$$reportNull$$$0(1);
        }
        super(library, elementClass, project);
    }

    @NotNull
    public Map<String, TapestryParameter> getParameters() {
        if (this._parametersCache != null && this.getElementClass().getFile().getFile().lastModified() <= this._parametersCacheTimestamp) {
            Map<String, TapestryParameter> map = this._parametersCache;
            if (map == null) {
                ParameterReceiverElement.$$$reportNull$$$0(2);
            }
            return map;
        }
        THashMap _parameters = new THashMap();
        _parameters.put("mixins", new DummyTapestryParameter(this.getProject(), "mixins", false));
        this._parametersCacheTimestamp = this.getElementClass().getFile().getFile().lastModified();
        Map<String, IJavaField> fields = this.getElementClass().getFields(true);
        for (IJavaField field : fields.values()) {
            if (!field.isPrivate() || !field.getAnnotations().containsKey("org.apache.tapestry5.annotations.Parameter") || !field.isValid()) continue;
            TapestryParameter parameter = new TapestryParameter(this.getElementClass(), field);
            _parameters.put(parameter.getName(), parameter);
        }
        Map<String, TapestryParameter> map = this._parametersCache = Collections.unmodifiableMap(_parameters);
        if (map == null) {
            ParameterReceiverElement.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Map<String, TapestryParameter> getRequiredParameters() {
        Map<String, TapestryParameter> parameters = this.getParameters();
        THashMap requiredParameters = new THashMap();
        for (TapestryParameter parameter : parameters.values()) {
            if (!parameter.isRequired()) continue;
            requiredParameters.put(parameter.getName(), parameter);
        }
        THashMap tHashMap = requiredParameters;
        if (tHashMap == null) {
            ParameterReceiverElement.$$$reportNull$$$0(4);
        }
        return tHashMap;
    }

    public Map<String, TapestryParameter> getOptionalParameters() {
        Map<String, TapestryParameter> parameters = this.getParameters();
        THashMap optionalParameters = new THashMap();
        for (TapestryParameter parameter : parameters.values()) {
            if (parameter.isRequired()) continue;
            optionalParameters.put(parameter.getName(), parameter);
        }
        return optionalParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

