/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.toclasschain;

import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.externalizable.toclasschain.ToClassExternalizer;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.util.PathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.chain.Context;

public class PageExternalizer
extends ToClassExternalizer {
    @Override
    public boolean execute(Context context) throws Exception {
        if (!super.execute(context)) {
            return false;
        }
        if (!(this.getContext().getElement() instanceof Page)) {
            return false;
        }
        Page page = (Page)this.getContext().getElement();
        IJavaField field = page.getProject().getJavaTypeCreator().createField(PathUtils.getLastPathElement(page.getName()), page.getElementClass(), true, true);
        String suggestedFieldName = this.suggestName(field.getName(), new ArrayList<String>(this.getContext().getTargetClass().getFields(false).keySet()));
        if (!suggestedFieldName.equals(field.getName())) {
            field = page.getProject().getJavaTypeCreator().createField(suggestedFieldName, page.getElementClass(), true, true);
        }
        page.getProject().getJavaTypeCreator().createFieldAnnotation(field, "org.apache.tapestry5.annotations.InjectPage", new HashMap<String, String>());
        String serialized = field.getStringRepresentation();
        if (page.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), page.getElementClass())) {
            serialized = serialized.replace(page.getElementClass().getFullyQualifiedName(), page.getElementClass().getName());
        }
        if (page.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), page.getProject().getJavaTypeFinder().findType("org.apache.tapestry5.annotations.InjectPage", true))) {
            serialized = serialized.replace("org.apache.tapestry5.annotations.InjectPage", "InjectPage");
        }
        this.getContext().setResult("\n" + serialized + "\n");
        return true;
    }
}

