/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.documentation.wrapper;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresentationElementDocumentationWrapper {
    private Document _document;
    private String _description;
    private final Map<String, String> _parameterDescriptions = new HashMap<String, String>();
    private String _examples;
    private String _notes;

    public PresentationElementDocumentationWrapper() {
    }

    public PresentationElementDocumentationWrapper(URL url) throws Exception {
        this._document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url.openStream());
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description;
        }
        this._description = "";
        if (this._document == null) {
            return this._description;
        }
        NodeList descriptions = this._document.getDocumentElement().getElementsByTagName("description");
        if (descriptions.getLength() > 0) {
            this._description = descriptions.item(0).getTextContent();
        }
        return this._description;
    }

    public String getParameterDescription(String name) {
        if (this._parameterDescriptions.containsKey(name)) {
            return this._parameterDescriptions.get(name);
        }
        if (this._document == null) {
            return "";
        }
        NodeList parameters = this._document.getDocumentElement().getElementsByTagName("parameter");
        for (int i = 0; i < parameters.getLength(); ++i) {
            Node parameter = parameters.item(i);
            String parameterName = parameter.getAttributes().getNamedItem("name").getTextContent();
            if (!parameterName.equals(name)) continue;
            this._parameterDescriptions.put(name, parameter.getTextContent());
            return parameter.getTextContent();
        }
        return "";
    }

    public String getExamples() {
        if (this._examples != null) {
            return this._examples;
        }
        this._examples = "";
        if (this._document == null) {
            return this._examples;
        }
        NodeList descriptions = this._document.getDocumentElement().getElementsByTagName("examples");
        if (descriptions.getLength() > 0) {
            this._examples = descriptions.item(0).getTextContent();
        }
        return this._examples;
    }

    public String getNotes() {
        if (this._notes != null) {
            return this._notes;
        }
        this._notes = "";
        if (this._document == null) {
            return this._notes;
        }
        NodeList descriptions = this._document.getDocumentElement().getElementsByTagName("notes");
        if (descriptions.getLength() > 0) {
            this._notes = descriptions.item(0).getTextContent();
        }
        return this._notes;
    }
}

