/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Library
implements Comparable {
    private final String _id;
    private final String _basePackage;
    private final TapestryProject _project;
    @Nullable
    private String myShortName;

    public Library(String id, String basePackage, TapestryProject project) {
        this(id, basePackage, project, null);
    }

    public Library(String id, String basePackage, TapestryProject project, @Nullable String libraryShortName) {
        this._id = id;
        this._basePackage = basePackage;
        this._project = project;
        this.myShortName = libraryShortName;
    }

    public String getId() {
        return this._id;
    }

    public String getBasePackage() {
        return this._basePackage;
    }

    @Nullable
    public String getShortName() {
        return this.myShortName;
    }

    public Map<String, PresentationLibraryElement> getComponents() {
        return this.findElements("components", this._basePackage);
    }

    public Map<String, PresentationLibraryElement> getAbstractComponents() {
        return this.findElements("base", this._basePackage);
    }

    public Map<String, PresentationLibraryElement> getPages() {
        return this.findElements("pages", this._basePackage);
    }

    public Map<String, PresentationLibraryElement> getMixins() {
        return this.findElements("mixins", this._basePackage);
    }

    public int compareTo(Object object) {
        return this.getBasePackage().compareTo(((Library)object).getBasePackage());
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Library && this.getBasePackage().equals(((Library)object).getBasePackage());
    }

    public int hashCode() {
        return this.getBasePackage().hashCode();
    }

    private Map<String, PresentationLibraryElement> findElements(String componentsOrPages, String basePackage) {
        THashMap components = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String>(){

            public int computeHashCode(String object) {
                return StringUtil.stringHashCodeInsensitive((CharSequence)object);
            }

            public boolean equals(String o1, String o2) {
                return o1.equalsIgnoreCase(o2);
            }
        });
        for (IJavaClassType type : this._project.getJavaTypeFinder().findTypesInPackageRecursively(basePackage + "." + componentsOrPages, true)) {
            try {
                PresentationLibraryElement element = PresentationLibraryElement.createElementInstance(this, type, this._project);
                components.put(element.getName(), element);
            }
            catch (NotTapestryElementException notTapestryElementException) {}
        }
        return components;
    }
}

