/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.util.CachedValue;
import gnu.trove.THashMap;
import java.util.Map;

public class MappingDataCache
extends FileBasedUserDataCache<Map<String, String>> {
    private final Key<CachedValue<Map<String, String>>> ourCachedIdsValueKey = Key.create((String)"tapestry.mapping.cached.value");
    private static final String TAPESTRY_MAPPING_FQN = "org.apache.tapestry5.services.LibraryMapping";
    private static final String TAPESTRY_MAPPING_TEST_FQN = "LibraryMapping";

    protected Key<CachedValue<Map<String, String>>> getKey() {
        return this.ourCachedIdsValueKey;
    }

    protected Map<String, String> doCompute(PsiFile file) {
        THashMap result = new THashMap();
        if (file instanceof PsiCompiledElement) {
            PsiElement element = file.getNavigationElement();
            if (element != file && element instanceof PsiFile) {
                file = (PsiFile)element;
            } else {
                PsiElement mirror = ((PsiCompiledElement)file).getMirror();
                if (mirror instanceof PsiFile) {
                    file = (PsiFile)mirror;
                }
            }
        }
        file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Map)result){
            final /* synthetic */ Map val$result;
            {
                this.val$result = map;
            }

            public void visitNewExpression(PsiNewExpression expression) {
                String classReferenceQualifiedName;
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                String string = classReferenceQualifiedName = classReference != null ? classReference.getQualifiedName() : null;
                if (MappingDataCache.TAPESTRY_MAPPING_FQN.equals(classReferenceQualifiedName) || ApplicationManager.getApplication().isUnitTestMode() && MappingDataCache.TAPESTRY_MAPPING_TEST_FQN.equals(classReferenceQualifiedName)) {
                    PsiExpression[] expressions;
                    PsiExpressionList argumentList = expression.getArgumentList();
                    PsiExpression[] psiExpressionArray = expressions = argumentList == null ? null : argumentList.getExpressions();
                    if (expressions != null && expressions.length == 2) {
                        String prefix = MappingDataCache.calculateExprValue(expressions[0]);
                        String packageName = MappingDataCache.calculateExprValue(expressions[1]);
                        if (prefix != null && packageName != null) {
                            this.val$result.put(prefix, packageName);
                        }
                    }
                }
                super.visitNewExpression(expression);
            }
        });
        return result;
    }

    protected static String calculateExprValue(PsiExpression expression) {
        if (expression instanceof PsiJavaReference) {
            Object constantValue;
            PsiElement resolve = ((PsiJavaReference)expression).resolve();
            if (resolve instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && ((PsiField)resolve).hasInitializer() && (constantValue = ((PsiField)resolve).computeConstantValue()) instanceof String) {
                return (String)constantValue;
            }
        } else if (expression instanceof PsiLiteralExpression) {
            return StringUtil.unquoteString((String)expression.getText());
        }
        return null;
    }
}

