/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.HealthTab;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansTab;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationEndpointsTab
extends AdditionalTabComponent {
    public static final DataKey<EndpointTab> SELECTED_TAB_KEY = DataKey.create((String)"springBootEndpointTab");
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    private final ProcessHandler myProcessHandler;
    private final TabbedPaneWrapper myWrapper;
    private final List<EndpointTab> myTabs;
    private volatile boolean myActuatorsEnabled;
    private volatile boolean myMappingsEnabled;
    private final LiveProperty.LivePropertyListener myReadyStateListener;
    private SpringBootApplicationLifecycleManager.InfoListener myInfoListener;

    public SpringBootApplicationEndpointsTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myTabs = new ArrayList<EndpointTab>();
        this.myActuatorsEnabled = false;
        this.myMappingsEnabled = false;
        this.myRunConfiguration = runConfiguration;
        this.myProcessHandler = processHandler;
        this.myWrapper = new TabbedPaneWrapper((Disposable)this){

            protected TabbedPane createTabbedPane(int tabPlacement) {
                TabbedPane tabbedPane = super.createTabbedPane(tabPlacement);
                if (tabbedPane instanceof JBTabsPaneImpl) {
                    JBTabs tabs = ((JBTabsPaneImpl)tabbedPane).getTabs();
                    DefaultActionGroup popupGroup = new DefaultActionGroup();
                    popupGroup.add((AnAction)new FocusOnStartAction(tabs));
                    tabs.setPopupGroup((ActionGroup)popupGroup, "unknown", true);
                }
                return tabbedPane;
            }
        };
        this.add(this.myWrapper.getComponent(), "Center");
        this.myTabs.add(new LiveBeansTab(runConfiguration, processHandler));
        HealthTab healthTab = new HealthTab(runConfiguration, processHandler);
        this.myTabs.add(healthTab);
        RequestMappingsTab mappingsTab = new RequestMappingsTab(runConfiguration, processHandler);
        this.myTabs.add(mappingsTab);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (runConfiguration == null) {
                SpringBootApplicationEndpointsTab.$$$reportNull$$$0(4);
            }
            DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
                if (runConfiguration == null) {
                    SpringBootApplicationEndpointsTab.$$$reportNull$$$0(5);
                }
                this.myActuatorsEnabled = SpringBootLibraryUtil.hasActuators((Module)runConfiguration.getModule());
                if (!this.myActuatorsEnabled) {
                    healthTab.showMessage(SpringBootRunBundle.message("spring.boot.application.endpoints.error.actuator.starter.disabled", new Object[0]));
                    mappingsTab.showMessage(SpringBootRunBundle.message("spring.boot.application.endpoints.error.actuator.starter.disabled", new Object[0]));
                } else {
                    this.myMappingsEnabled = SpringBootLibraryUtil.hasRequestMappings((Module)runConfiguration.getModule());
                    if (!this.myMappingsEnabled) {
                        mappingsTab.showMessage(SpringBootRunBundle.message("spring.boot.application.endpoints.error.request.mappings.disabled", new Object[0]));
                    }
                }
            });
        });
        String selectedTabId = SpringBootEndpointsTabSettings.getInstance(this.getProject()).getSelectedTab();
        this.myTabs.forEach(tab -> {
            this.myWrapper.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), null);
            int tabIndex = this.myWrapper.getTabCount() - 1;
            tab.setTooltipChangeListener(tooltip -> this.myWrapper.setToolTipTextAt(tabIndex, tooltip));
            if (tab.getId().equals(selectedTabId)) {
                this.myWrapper.setSelectedIndex(tabIndex);
            }
            Disposer.register((Disposable)this, (Disposable)tab);
        });
        this.myReadyStateListener = new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringBootApplicationEndpointsTab.this.myTabs.forEach(tab -> {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    tab.showMessage(SpringBootRunBundle.message("spring.boot.application.endpoints.application.ready.check.failed", e.getLocalizedMessage()));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computationFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$computationFailed$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        SpringBootApplicationInfo info = this.getInfo();
        if (info != null) {
            info.getReadyState().addPropertyListener(this.myReadyStateListener);
            this.myTabs.forEach(tab -> tab.initPropertyListener(info));
        } else {
            this.myInfoListener = new SpringBootApplicationLifecycleManager.InfoListener(){

                public void infoAdded(@NotNull ProcessHandler handler, @NotNull SpringBootApplicationInfo info) {
                    if (handler == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (info == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (SpringBootApplicationEndpointsTab.this.myProcessHandler.equals(handler)) {
                        info.getReadyState().addPropertyListener(SpringBootApplicationEndpointsTab.this.myReadyStateListener);
                        SpringBootApplicationEndpointsTab.this.myTabs.forEach(tab -> {
                            if (info == null) {
                                3.$$$reportNull$$$0(4);
                            }
                            tab.initPropertyListener(info);
                        });
                    }
                }

                public void infoRemoved(@NotNull ProcessHandler handler, @NotNull SpringBootApplicationInfo info) {
                    if (handler == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (info == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    if (SpringBootApplicationEndpointsTab.this.myProcessHandler.equals(handler)) {
                        SpringBootApplicationLifecycleManager.getInstance((Project)SpringBootApplicationEndpointsTab.this.getProject()).removeInfoListener((SpringBootApplicationLifecycleManager.InfoListener)this);
                        SpringBootApplicationEndpointsTab.this.myTabs.forEach(EndpointTab::infoRemoved);
                        AppUIUtil.invokeLaterIfProjectAlive((Project)SpringBootApplicationEndpointsTab.this.getProject(), () -> {
                            for (int i = 0; i < SpringBootApplicationEndpointsTab.this.myWrapper.getTabCount(); ++i) {
                                SpringBootApplicationEndpointsTab.this.myWrapper.setIconAt(i, IconLoader.getDisabledIcon((Icon)((EndpointTab)SpringBootApplicationEndpointsTab.this.myTabs.get(i)).getIcon()));
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "info";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoRemoved";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$infoAdded$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            SpringBootApplicationLifecycleManager.getInstance((Project)this.getProject()).addInfoListener(this.myInfoListener);
        }
        this.myWrapper.getComponent().putClientProperty("DataProvider", new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (SELECTED_TAB_KEY.getName().equals(dataId)) {
                    return SpringBootApplicationEndpointsTab.this.getSelectedTab();
                }
                return null;
            }
        });
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myWrapper.getComponent();
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(new AnAction(){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setText(SpringBootRunBundle.message("spring.boot.application.endpoints.refresh.action.name", new Object[0]));
                presentation.setDescription(SpringBootRunBundle.message("spring.boot.application.endpoints.refresh.action.description", new Object[0]));
                presentation.setIcon(AllIcons.Actions.Refresh);
                SpringBootApplicationInfo info = SpringBootApplicationEndpointsTab.this.getInfo();
                EndpointTab selectedTab = (EndpointTab)e.getData(SELECTED_TAB_KEY);
                if (info != null && !Boolean.FALSE.equals(info.getReadyState().getValue()) && selectedTab != null) {
                    if (selectedTab instanceof RequestMappingsTab) {
                        presentation.setEnabled(SpringBootApplicationEndpointsTab.this.myActuatorsEnabled && SpringBootApplicationEndpointsTab.this.myMappingsEnabled);
                    } else {
                        presentation.setEnabled(selectedTab instanceof LiveBeansTab || SpringBootApplicationEndpointsTab.this.myActuatorsEnabled);
                    }
                    selectedTab.updateRefreshAction(e, info);
                } else {
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                SpringBootApplicationInfo info = SpringBootApplicationEndpointsTab.this.getInfo();
                if (info != null && info.getReadyState().getValue() == null) {
                    info.getReadyState().compute();
                    SpringBootApplicationEndpointsTab.this.myTabs.forEach(tab -> tab.showLoading());
                    return;
                }
                ((EndpointTab)SpringBootApplicationEndpointsTab.this.myTabs.get(SpringBootApplicationEndpointsTab.this.myWrapper.getSelectedIndex())).refresh();
            }
        });
        actionGroup.addSeparator();
        this.myTabs.forEach(tab -> actionGroup.addAll(tab.getToolbarActions()));
        return actionGroup;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return this.myWrapper.getComponent();
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @NotNull
    public String getTabTitle() {
        String string = SpringBootRunBundle.message("spring.boot.application.endpoints.tab.title", new Object[0]);
        if (string == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void dispose() {
        SpringBootApplicationInfo info;
        if (this.myInfoListener != null) {
            SpringBootApplicationLifecycleManager.getInstance((Project)this.getProject()).removeInfoListener(this.myInfoListener);
        }
        if ((info = this.getInfo()) != null) {
            info.getReadyState().removePropertyListener(this.myReadyStateListener);
        }
    }

    @NotNull
    private Project getProject() {
        Project project = this.myRunConfiguration.getProject();
        if (project == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Nullable
    private EndpointTab getSelectedTab() {
        return this.myWrapper.getSelectedIndex() >= 0 ? this.myTabs.get(this.myWrapper.getSelectedIndex()) : null;
    }

    @Nullable
    private SpringBootApplicationInfo getInfo() {
        Project project = this.getProject();
        if (project.isDisposed()) {
            return null;
        }
        return SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfo(this.myProcessHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FocusOnStartAction
    extends AnAction
    implements Toggleable {
        private final JBTabs myTabs;

        FocusOnStartAction(JBTabs tabs) {
            super(ActionsBundle.actionText((String)"Runner.FocusOnStartup"), ActionsBundle.actionDescription((String)"Runner.FocusOnStartup"), null);
            this.myTabs = tabs;
        }

        public void update(AnActionEvent e) {
            EndpointTab currentTab = this.getCurrentTab();
            boolean visible = currentTab != null;
            e.getPresentation().setVisible(visible);
            if (visible) {
                e.getPresentation().putClientProperty("selected", (Object)this.isToFocus(currentTab));
            }
            super.update(e);
        }

        public void actionPerformed(AnActionEvent e) {
            EndpointTab currentTab = this.getCurrentTab();
            if (currentTab == null) {
                return;
            }
            boolean isToFocus = this.isToFocus(currentTab);
            SpringBootEndpointsTabSettings.getInstance(SpringBootApplicationEndpointsTab.this.getProject()).setSelectedTab(isToFocus ? null : currentTab.getId());
        }

        private boolean isToFocus(@NotNull EndpointTab tab) {
            if (tab == null) {
                FocusOnStartAction.$$$reportNull$$$0(0);
            }
            return tab.getId().equals(SpringBootEndpointsTabSettings.getInstance(SpringBootApplicationEndpointsTab.this.getProject()).getSelectedTab());
        }

        @Nullable
        private EndpointTab getCurrentTab() {
            int index;
            TabInfo info = this.myTabs.getTargetInfo();
            int n = index = info == null ? SpringBootApplicationEndpointsTab.this.myWrapper.getSelectedIndex() : this.myTabs.getIndexOf(info);
            if (index >= 0) {
                return (EndpointTab)SpringBootApplicationEndpointsTab.this.myTabs.get(index);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tab", "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$FocusOnStartAction", "isToFocus"));
        }
    }
}

