/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsPanel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestMappingsConfigurable
extends DialogWrapper {
    private JPanel myRootPanel;
    private JPanel myFieldPanel;
    private TextFieldWithCompletion myPathField;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    @NotNull
    private final List<LiveRequestMapping> myMappings;

    public RequestMappingsConfigurable(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull List<LiveRequestMapping> mappings) {
        if (project == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(1);
        }
        if (mappings == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myMappings = mappings;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.path.dialog.title", new Object[0]));
    }

    private void createUIComponents() {
        this.myFieldPanel = new JPanel(new BorderLayout());
        this.myFieldPanel.setPreferredSize((Dimension)new JBDimension(300, -1));
        String text = this.myRunConfiguration.getUrlPath();
        if (text == null) {
            text = "";
        }
        this.myPathField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletionListProvider<LiveRequestMapping>(this.myMappings){

            @NotNull
            protected String getLookupString(@NotNull LiveRequestMapping item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = item.getPath();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            protected String getTailText(@NotNull LiveRequestMapping item) {
                if (item == null) {
                    1.$$$reportNull$$$0(2);
                }
                return RequestMappingsPanel.getDisplayRequestMethods(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, true, text);
        this.myFieldPanel.add((Component)this.myPathField, "Center");
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPathField;
    }

    protected void doOKAction() {
        RequestMappingsConfigurable.updatePath(this.myProject, this.myRunConfiguration, this.myPathField.getText());
        super.doOKAction();
    }

    static void updatePath(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, String path) {
        RunManagerImpl runManager;
        RunnerAndConfigurationSettings configurationSettings;
        if (project == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(4);
        }
        if ((configurationSettings = (runManager = (RunManagerImpl)RunManager.getInstance((Project)project)).findConfigurationByName(runConfiguration.getName())) == null) {
            return;
        }
        if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
            ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).setUrlPath(path);
            runConfiguration.setUrlPath(path);
            runManager.fireRunConfigurationChanged(configurationSettings);
        }
    }

    public static String getApplicationUrl(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull Project project, @NotNull ProcessHandler handler, @Nullable String mapping) {
        String mappingPath;
        SpringBootApplicationInfo info;
        if (runConfiguration == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(5);
        }
        if (project == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(6);
        }
        if (handler == null) {
            RequestMappingsConfigurable.$$$reportNull$$$0(7);
        }
        if ((info = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfo(handler)) == null) {
            return null;
        }
        int serverPort = RequestMappingsConfigurable.getServerPort(info);
        if (serverPort <= 0) {
            return null;
        }
        String path = "";
        String scheme = "http";
        String address = NetUtils.getLocalHostString();
        SpringBootApplicationServerConfiguration serverConfiguration = (SpringBootApplicationServerConfiguration)info.getServerConfiguration().getValue();
        if (serverConfiguration != null) {
            String serverAddress;
            String servletPath;
            String contextPath;
            if (serverConfiguration.isSslEnabled()) {
                scheme = "https";
            }
            if ((contextPath = serverConfiguration.getContextPath()) != null) {
                path = path + contextPath;
            }
            if ((servletPath = serverConfiguration.getServletPath()) != null) {
                path = path + servletPath;
            }
            if (StringUtil.isNotEmpty((String)(serverAddress = serverConfiguration.getAddress()))) {
                address = serverAddress;
            }
        }
        String string = mappingPath = mapping == null ? runConfiguration.getUrlPath() : mapping;
        if (mappingPath == null) {
            mappingPath = "/";
        } else if (!mappingPath.startsWith("/")) {
            mappingPath = "/" + mappingPath;
        }
        path = path + mappingPath;
        return scheme + "://" + address + ":" + serverPort + path;
    }

    private static int getServerPort(SpringBootApplicationInfo info) {
        if (!Boolean.TRUE.equals(info.getReadyState().getValue())) {
            return -1;
        }
        Integer serverPort = (Integer)info.getServerPort().getValue();
        return serverPort == null ? -1 : serverPort;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.endpoints.mappings.path.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.myFieldPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

