/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.spring.boot.run.lifecycle.RelaxedNamesByParts;
import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationConnector
extends SpringBootJmxConnector {
    static final String ENDPOINTS_JMX_DOMAIN_PROPERTY_1X = "endpoints.jmx.domain";
    static final String ENDPOINTS_JMX_DOMAIN_PROPERTY_2X = "management.endpoints.jmx.domain";
    static final String SPRING_JMX_DEFAULT_DOMAIN_PROPERTY = "spring.jmx.default-domain";
    static final String ENDPOINTS_JMX_ENABLED_PROPERTY_1X = "endpoints.jmx.enabled";
    static final String ENDPOINTS_JMX_ENABLED_PROPERTY_2X = "management.endpoints.jmx.enabled";
    static final String ENDPOINTS_JMX_EXPOSE_PROPERTY_2X = "management.endpoints.jmx.expose";
    static final String ENDPOINTS_JMX_EXCLUDE_PROPERTY_2X = "management.endpoints.jmx.exclude";
    static final String ENDPOINTS_ENABLED_PROPERTY_1X = "endpoints.enabled";
    static final String ENDPOINTS_ENABLED_PROPERTY_2X = "management.endpoints.enabled-by-default";
    static final String ENDPOINTS_ID_ENABLED_PROPERTY_1X = "endpoints.%s.enabled";
    static final String ENDPOINTS_ID_ENABLED_PROPERTY_2X = "management.endpoints.%s.enabled";
    static final String SERVER_SSL_ENABLED_PROPERTY = "server.ssl.enabled";
    static final String SERVER_SSL_KEY_STORE_PROPERTY = "server.ssl.key-store";
    static final String SERVER_CONTEXT_PATH_PROPERTY_1X = "server.context-path";
    static final String SERVER_SERVLET_PATH_PROPERTY_1X = "server.servlet-path";
    static final String SERVER_CONTEXT_PATH_PROPERTY_2X = "server.servlet.context-path";
    static final String SERVER_SERVLET_PATH_PROPERTY_2X = "server.servlet.path";
    static final String SERVER_ADDRESS_PROPERTY = "server.address";
    private static final String READY_ATTR = "Ready";
    private static final String GET_PROPERTY_OPERATION = "getProperty";
    private static final String LOCAL_SERVER_PORT_PROPERTY = "local.server.port";

    SpringBootApplicationConnector(String serviceUrl, String objectName) {
        super(serviceUrl, objectName);
    }

    Object getProperty(@NotNull String propertyName) throws Exception {
        Object value;
        if (propertyName == null) {
            SpringBootApplicationConnector.$$$reportNull$$$0(0);
        }
        if ((value = this.doGetProperty(propertyName)) != null) {
            return value;
        }
        Set<String> names = RelaxedNamesByParts.generateRelaxedNamesByParts(propertyName);
        names.remove(propertyName);
        for (String name : names) {
            value = this.doGetProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    boolean getBooleanProperty(@NotNull String propertyName, boolean defaultValue) throws Exception {
        Object value;
        if (propertyName == null) {
            SpringBootApplicationConnector.$$$reportNull$$$0(1);
        }
        if ((value = this.getProperty(propertyName)) instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    int getServerPort() throws Exception {
        Object value = this.getProperty(LOCAL_SERVER_PORT_PROPERTY);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    boolean isReady() throws Exception {
        try {
            Object value = this.getJmxConnection().getAttribute(this.getObjectName(), READY_ATTR);
            return value instanceof Boolean ? (Boolean)value : false;
        }
        catch (InstanceNotFoundException ex) {
            return false;
        }
    }

    private Object doGetProperty(String propertyName) throws Exception {
        return this.getJmxConnection().invoke(this.getObjectName(), GET_PROPERTY_OPERATION, new String[]{propertyName}, new String[]{String.class.getName()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "propertyName";
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = GET_PROPERTY_OPERATION;
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBooleanProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

