/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class RelaxedNamesByParts {
    RelaxedNamesByParts() {
    }

    static Set<String> generateRelaxedNamesByParts(String source) {
        LinkedHashSet variations = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAll((Collection)variations, (Iterable)new RelaxedNames(source));
        List parts = StringUtil.split((String)source, (String)".");
        List relaxedNamesParts = parts.stream().map(RelaxedNames::new).collect(Collectors.toCollection(ArrayList::new));
        RelaxedNamesByParts.addVariations(variations, relaxedNamesParts);
        return variations;
    }

    private static void addVariations(Set<String> names, List<RelaxedNames> relaxedNamesParts) {
        if (relaxedNamesParts.isEmpty()) {
            return;
        }
        RelaxedNames prefixes = relaxedNamesParts.remove(0);
        if (relaxedNamesParts.isEmpty()) {
            ContainerUtil.addAll(names, (Iterable)prefixes);
            return;
        }
        LinkedHashSet suffixes = ContainerUtil.newLinkedHashSet();
        RelaxedNamesByParts.addVariations(suffixes, relaxedNamesParts);
        for (String prefix : prefixes) {
            for (String suffix : suffixes) {
                names.add(prefix + "." + suffix);
                names.add(prefix + "_" + suffix);
            }
        }
    }
}

