/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AbstractLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class ReadyStateLiveProperty
extends AbstractLiveProperty<Boolean> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.run.lifecycle.ReadyStateLiveProperty");
    private static final long STATE_CHECKING_RETRY_INTERVAL = 500L;
    private static final long STATE_CHECKING_DELAY_INTERVAL = 1000L;
    private static final long STATE_CHECKING_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private static final int STATE_CHECKING_RETRY_COUNT = 20;
    private final LiveProperty<String> myApplicationAdminJmxName;
    private final LiveProperty<String> myServiceUrl;
    private final Object myLock = new Object();
    private Runnable myChecker;
    private long myStart;
    private long myRetryCount;
    private volatile boolean myDisposed = false;

    ReadyStateLiveProperty(LiveProperty<String> applicationAdminJmxName, LiveProperty<String> serviceUrl, Disposable parent) {
        super(Boolean.FALSE);
        this.myApplicationAdminJmxName = applicationAdminJmxName;
        this.myServiceUrl = serviceUrl;
        this.myServiceUrl.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                if (!StringUtil.isEmpty((String)((String)ReadyStateLiveProperty.this.myServiceUrl.getValue()))) {
                    ReadyStateLiveProperty.this.startChecking();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getCause() != null && !(e.getCause() instanceof Exception)) {
                    Object object = ReadyStateLiveProperty.this.myLock;
                    synchronized (object) {
                        ReadyStateLiveProperty.this.myRetryCount++;
                        if (ReadyStateLiveProperty.this.myRetryCount < 20L && System.currentTimeMillis() - ReadyStateLiveProperty.this.myStart <= STATE_CHECKING_TIMEOUT) {
                            JobScheduler.getScheduler().schedule(() -> ((LiveProperty)ReadyStateLiveProperty.this.myServiceUrl).compute(), 500L, TimeUnit.MILLISECONDS);
                            return;
                        }
                    }
                }
                ReadyStateLiveProperty.this.setValue(null);
                ReadyStateLiveProperty.this.getListeners().forEach(listener -> {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    listener.computationFailed(e);
                });
                ReadyStateLiveProperty.this.getListeners().forEach(LiveProperty.LivePropertyListener::computationFinished);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/ReadyStateLiveProperty$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computationFailed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$computationFailed$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
    }

    public void dispose() {
        this.myDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStart = System.currentTimeMillis();
            this.myRetryCount = 0L;
        }
        JobScheduler.getScheduler().schedule(() -> this.myServiceUrl.compute(), 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startChecking() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myChecker != null) {
                return;
            }
            this.setValue(Boolean.FALSE);
            this.myChecker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block27: {
                        if (ReadyStateLiveProperty.this.myDisposed || Boolean.TRUE.equals(ReadyStateLiveProperty.this.getValue())) {
                            return;
                        }
                        boolean timeoutExceeded = false;
                        Object object = ReadyStateLiveProperty.this.myLock;
                        synchronized (object) {
                            if (System.currentTimeMillis() - ReadyStateLiveProperty.this.myStart > STATE_CHECKING_TIMEOUT) {
                                ReadyStateLiveProperty.this.setValue(null);
                                ReadyStateLiveProperty.this.myChecker = null;
                                timeoutExceeded = true;
                            }
                        }
                        if (timeoutExceeded) {
                            LifecycleException e = new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.application.ready.check.timeout.exceeded", new Object[0]), null);
                            ReadyStateLiveProperty.this.getListeners().forEach(listener -> listener.computationFailed(e));
                            ReadyStateLiveProperty.this.getListeners().forEach(LiveProperty.LivePropertyListener::computationFinished);
                            return;
                        }
                        try (SpringBootApplicationConnector connector = new SpringBootApplicationConnector((String)ReadyStateLiveProperty.this.myServiceUrl.getValue(), (String)ReadyStateLiveProperty.this.myApplicationAdminJmxName.getValue());){
                            if (connector.isReady()) {
                                ReadyStateLiveProperty.this.setValue(Boolean.TRUE);
                                ReadyStateLiveProperty.this.getListeners().forEach(LiveProperty.LivePropertyListener::propertyChanged);
                                ReadyStateLiveProperty.this.getListeners().forEach(LiveProperty.LivePropertyListener::computationFinished);
                                return;
                            }
                        }
                        catch (Exception e) {
                            boolean retryCountExceeded = false;
                            Object object2 = ReadyStateLiveProperty.this.myLock;
                            synchronized (object2) {
                                ReadyStateLiveProperty.this.myRetryCount++;
                                if (ReadyStateLiveProperty.this.myRetryCount >= 20L) {
                                    ReadyStateLiveProperty.this.setValue(null);
                                    ReadyStateLiveProperty.this.myChecker = null;
                                    retryCountExceeded = true;
                                }
                            }
                            if (!retryCountExceeded) break block27;
                            LOG.debug((Throwable)e);
                            ReadyStateLiveProperty.this.getListeners().forEach(listener -> listener.computationFailed(e));
                            ReadyStateLiveProperty.this.getListeners().forEach(LiveProperty.LivePropertyListener::computationFinished);
                            return;
                        }
                    }
                    JobScheduler.getScheduler().schedule(this, 500L, TimeUnit.MILLISECONDS);
                }
            };
            ApplicationManager.getApplication().executeOnPooledThread(this.myChecker);
        }
    }
}

