/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.net.NetUtils;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JmxServiceUrlLiveProperty
extends AsyncLiveProperty<String> {
    private static final String JMX_CONNECTION_ADDRESS_PROPERTY = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String LOCAL_JMX_CONNECTOR_URL = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private final ProcessHandler myProcessHandler;

    JmxServiceUrlLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent, ProcessHandler processHandler) {
        super(errorHandler, parent, "");
        this.myProcessHandler = processHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doCompute() throws LifecycleException {
        String string;
        String pid = String.valueOf(OSProcessUtil.getProcessID((Process)((BaseOSProcessHandler)this.myProcessHandler).getProcess()));
        VirtualMachine vm = null;
        try {
            vm = JmxServiceUrlLiveProperty.attachVirtualMachine(pid);
            String url = vm.getAgentProperties().getProperty(JMX_CONNECTION_ADDRESS_PROPERTY);
            if (StringUtil.isEmpty((String)url)) {
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.jmx.agent.not.loaded", new Object[0]), null);
            }
            string = url;
            if (vm == null) return string;
        }
        catch (Throwable e) {
            try {
                String url2 = this.getConnectionUrlByPort();
                if (url2 == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e);
                String string2 = url2;
                return string2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (vm != null) {
                    try {
                        vm.detach();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            vm.detach();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    @Nullable
    private String getConnectionUrlByPort() {
        Integer jmxPort = (Integer)this.myProcessHandler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
        if (jmxPort == null || jmxPort <= 0) {
            return null;
        }
        return String.format(LOCAL_JMX_CONNECTOR_URL, NetUtils.getLocalHostString(), jmxPort);
    }

    @NotNull
    private static VirtualMachine attachVirtualMachine(String id) throws IOException, AttachNotSupportedException {
        if (VirtualMachine.list().stream().map(VirtualMachineDescriptor::id).noneMatch(id::equals)) {
            throw new AttachNotSupportedException("AttachProvider for the vm is not found");
        }
        VirtualMachine virtualMachine = VirtualMachine.attach(id);
        if (virtualMachine == null) {
            JmxServiceUrlLiveProperty.$$$reportNull$$$0(0);
        }
        return virtualMachine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/JmxServiceUrlLiveProperty", "attachVirtualMachine"));
    }
}

