/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootActuatorConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class EndpointLiveProperty<T>
extends AsyncApplicationLiveProperty<T> {
    private static final String ENDPOINT_BEAN_NAME_SUFFIX = "Endpoint";
    private static final String ENDPOINT_WILDCARD = "*";
    private final String myEndpointId;
    private final String myEndpointName;
    private LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private LiveProperty<LiveBeansModel> myLiveBeansModel;

    EndpointLiveProperty(String endpointId, String endpointName, LiveProperty<String> applicationAdminJmxName, LiveProperty<String> serviceUrl, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(applicationAdminJmxName, serviceUrl, errorHandler, parent);
        this.myEndpointId = endpointId;
        this.myEndpointName = endpointName;
    }

    EndpointLiveProperty<T> withModuleDescriptor(LiveProperty<SpringBootModuleDescriptor> moduleDescriptor) {
        this.myModuleDescriptor = moduleDescriptor;
        return this;
    }

    EndpointLiveProperty<T> withLiveBeansModel(LiveProperty<LiveBeansModel> liveBeansModel) {
        this.myLiveBeansModel = liveBeansModel;
        return this;
    }

    @Override
    public T doCompute() throws LifecycleException {
        SpringBootModuleDescriptor moduleDescriptor;
        boolean isSB20 = false;
        if (this.myModuleDescriptor != null && (moduleDescriptor = (SpringBootModuleDescriptor)this.myModuleDescriptor.getValue()) != null) {
            if (!moduleDescriptor.isActuatorsEnabled()) {
                return null;
            }
            isSB20 = moduleDescriptor.isSB20();
        }
        String endpointDomain = "org.springframework.boot";
        String endpointDisabledMessage = null;
        try (SpringBootApplicationConnector connector = this.getApplicationConnector();){
            String endpointsJmxEnabledProperty = isSB20 ? "management.endpoints.jmx.enabled" : "endpoints.jmx.enabled";
            boolean endpointsJmxEnabled = connector.getBooleanProperty(endpointsJmxEnabledProperty, true);
            if (!endpointsJmxEnabled) {
                endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", endpointsJmxEnabledProperty);
            } else if (isSB20) {
                Set<String> exposed = EndpointLiveProperty.parseEndpointsList(connector.getProperty("management.endpoints.jmx.expose"));
                if (exposed.isEmpty() || exposed.contains(ENDPOINT_WILDCARD) || exposed.contains(this.myEndpointId)) {
                    Set<String> excluded = EndpointLiveProperty.parseEndpointsList(connector.getProperty("management.endpoints.jmx.exclude"));
                    if (!excluded.isEmpty() && (excluded.contains(ENDPOINT_WILDCARD) || excluded.contains(this.myEndpointId))) {
                        endpointsJmxEnabled = false;
                        endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.excluded", "management.endpoints.jmx.exclude");
                    }
                } else {
                    endpointsJmxEnabled = false;
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.not.exposed", "management.endpoints.jmx.expose");
                }
            }
            if (endpointsJmxEnabled) {
                String endpointsEnabledByDefaultProperty = isSB20 ? "management.endpoints.enabled-by-default" : "endpoints.enabled";
                boolean endpointsEnabledByDefault = connector.getBooleanProperty(endpointsEnabledByDefaultProperty, true);
                String endpointEnabledProperty = String.format(isSB20 ? "management.endpoints.%s.enabled" : "endpoints.%s.enabled", this.myEndpointId);
                boolean endpointEnabled = connector.getBooleanProperty(endpointEnabledProperty, endpointsEnabledByDefault);
                if (!endpointEnabled) {
                    String propertyName = endpointsEnabledByDefault ? endpointEnabledProperty : endpointsEnabledByDefaultProperty;
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", propertyName);
                } else {
                    Object o = connector.getProperty(isSB20 ? "management.endpoints.jmx.domain" : "endpoints.jmx.domain");
                    if (o instanceof String) {
                        endpointDomain = (String)o;
                    } else {
                        o = connector.getProperty("spring.jmx.default-domain");
                        if (o instanceof String) {
                            endpointDomain = (String)o;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
        }
        if (endpointDisabledMessage == null) {
            LiveBeansModel model;
            LiveBeansModel liveBeansModel = model = this.myLiveBeansModel != null ? (LiveBeansModel)this.myLiveBeansModel.getValue() : null;
            if (model != null) {
                List beans = model.getBeans();
                String endpointBeanName = this.myEndpointName + ENDPOINT_BEAN_NAME_SUFFIX;
                if (beans.stream().noneMatch(bean -> endpointBeanName.equals(bean.getId()))) {
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.bean.not.initialized", endpointBeanName);
                }
            }
        }
        String mbeanName = isSB20 ? StringUtil.capitalize((String)this.myEndpointId) : this.myEndpointName + ENDPOINT_BEAN_NAME_SUFFIX;
        Throwable throwable = null;
        try (SpringBootActuatorConnector connector = new SpringBootActuatorConnector(this.getServiceUrl(), endpointDomain, mbeanName);){
            T endpointsJmxEnabled = this.parseData(connector.getData(isSB20 ? this.myEndpointId : null));
            return endpointsJmxEnabled;
        }
        catch (Exception e) {
            try {
                if (endpointDisabledMessage != null) {
                    throw new LifecycleException(null, new LifecycleException(endpointDisabledMessage, null));
                }
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected abstract T parseData(@Nullable Object var1);

    @NotNull
    private static Set<String> parseEndpointsList(@Nullable Object value) {
        if (value == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                EndpointLiveProperty.$$$reportNull$$$0(0);
            }
            return set;
        }
        List endpoints = StringUtil.split((String)value.toString(), (String)",");
        Set<String> set = endpoints.stream().map(endpoint -> endpoint.trim()).collect(Collectors.toSet());
        if (set == null) {
            EndpointLiveProperty.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/EndpointLiveProperty", "parseEndpointsList"));
    }
}

