/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Set;

class ApplicationAdminJmxNameLiveProperty
extends AsyncLiveProperty<String> {
    private static final String JMX_NAME_PROPERTY_KEY = "spring.application.admin.jmx-name";
    private static final String SPRING_BOOT_APPLICATION_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private final Module myModule;
    private final Set<String> myActiveProfiles;

    ApplicationAdminJmxNameLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent, Module module, String activeProfiles) {
        super(errorHandler, parent, SPRING_BOOT_APPLICATION_OBJECT_NAME);
        this.myModule = module;
        String[] profiles = activeProfiles != null ? activeProfiles.split(",") : null;
        HashSet<String> profilesSet = new HashSet<String>();
        if (profiles != null) {
            for (String profile : profiles) {
                if ((profile = profile.trim()).isEmpty()) continue;
                profilesSet.add(profile);
            }
        }
        this.myActiveProfiles = profilesSet.isEmpty() ? null : profilesSet;
    }

    @Override
    protected String doCompute() {
        if (this.myModule == null) {
            return SPRING_BOOT_APPLICATION_OBJECT_NAME;
        }
        return (String)DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(() -> {
            SpringBootConfigValueSearcher searcher = SpringBootConfigValueSearcher.productionForProfiles((Module)this.myModule, (String)JMX_NAME_PROPERTY_KEY, this.myActiveProfiles);
            return (String)ObjectUtils.chooseNotNull((Object)searcher.findValueText(), (Object)SPRING_BOOT_APPLICATION_OBJECT_NAME);
        });
    }
}

