/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootCommandLineState;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.editor.SpringBootApplicationRunConfigurationEditor;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootApplicationEndpointsTab;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import icons.SpringBootRunIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringBootApplicationRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements SpringBootApplicationRunConfigurationBase,
SingleClassConfiguration,
CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private final SpringBootApplicationRunConfigurationBean myConfig = new SpringBootApplicationRunConfigurationBean();
    private final Map<String, String> myEnvs = new LinkedHashMap<String, String>();

    public SpringBootApplicationRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), factory);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getSpringBootMainClass());
    }

    public String suggestedName() {
        if (this.myConfig.SPRING_BOOT_MAIN_CLASS == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.myConfig.SPRING_BOOT_MAIN_CLASS);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new SpringBootApplicationRunConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        PsiClass mainClass = ((JavaRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.myConfig.SPRING_BOOT_MAIN_CLASS, "No Spring Boot application class specified");
        if (!SpringBootApplicationUtil.isSpringApplication((PsiClass)mainClass)) {
            throw new RuntimeConfigurationException("Not a valid Spring Boot application class");
        }
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), null);
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        List<SpringBootAdditionalParameter> parameters = this.myConfig.ADDITIONAL_PARAMETERS;
        for (int i = 0; i < parameters.size(); ++i) {
            SpringBootAdditionalParameter parameter = parameters.get(i);
            if (!StringUtil.isEmptyOrSpaces((String)parameter.getName())) continue;
            throw new RuntimeConfigurationWarning("Invalid override parameter name in row " + (i + 1));
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(2);
        }
        SpringBootCommandLineState state = new SpringBootCommandLineState(this, environment);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return state;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        XmlSerializer.deserializeInto((Object)this.myConfig, (Element)element);
        this.readModule(element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        XmlSerializer.serializeInto((Object)this.myConfig, (Element)element, (SerializationFilter)SERIALIZATION_FILTERS);
        this.writeModule(element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.SingleClassConfigurationAccessor((SingleClassConfiguration)this));
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
    }

    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    @Nullable
    public PsiClass getMainClass() {
        return SpringBootApplicationRunConfiguration.guessUastMainClass(((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getSpringBootMainClass()));
    }

    @Nullable
    public static PsiClass guessUastMainClass(@Nullable PsiClass springBootClass) {
        if (springBootClass == null) {
            return null;
        }
        PsiFile langFile = (PsiFile)ReadAction.compute(() -> {
            VirtualFile virtualFile = springBootClass.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            return springBootClass.getManager().findFile(virtualFile);
        });
        if (langFile == null) {
            return springBootClass;
        }
        UFile file = (UFile)UastContextKt.toUElement((PsiElement)langFile, UFile.class);
        if (file == null) {
            return springBootClass;
        }
        SmartList mainMethodCandidates = new SmartList();
        for (UClass uClass : file.getClasses()) {
            for (UMethod method : uClass.getMethods()) {
                if (!PsiMethodUtil.isMainMethod((PsiMethod)method)) continue;
                mainMethodCandidates.add(method);
            }
        }
        if (mainMethodCandidates.size() == 1) {
            return ((UMethod)mainMethodCandidates.get(0)).getContainingClass();
        }
        return springBootClass;
    }

    public void setMainClassName(String qualifiedName) {
        this.setSpringBootMainClass(qualifiedName);
    }

    public void setVMParameters(String value) {
        this.myConfig.VM_PARAMETERS = value;
    }

    public String getVMParameters() {
        return this.myConfig.VM_PARAMETERS;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.myConfig.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.myConfig.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.myConfig.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.myConfig.ALTERNATIVE_JRE_PATH = path;
    }

    @Nullable
    public String getRunClass() {
        PsiClass mainClass = this.getMainClass();
        return mainClass != null ? mainClass.getQualifiedName() : this.getSpringBootMainClass();
    }

    @Nullable
    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myConfig.PROGRAM_PARAMETERS = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.myConfig.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.myConfig.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value);
    }

    @Nullable
    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.myConfig.WORKING_DIRECTORY);
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(3);
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myConfig.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myConfig.PASS_PARENT_ENVS;
    }

    public Module getModule() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
    }

    public void setSpringBootMainClass(String springBootMainClass) {
        this.myConfig.SPRING_BOOT_MAIN_CLASS = springBootMainClass;
    }

    public String getSpringBootMainClass() {
        return this.myConfig.SPRING_BOOT_MAIN_CLASS;
    }

    public boolean isDebugMode() {
        return this.myConfig.DEBUG_MODE;
    }

    public void setDebugMode(boolean value) {
        this.myConfig.DEBUG_MODE = value;
    }

    public boolean isEnableLaunchOptimization() {
        return this.myConfig.ENABLE_LAUNCH_OPTIMIZATION;
    }

    public void setEnableLaunchOptimization(boolean value) {
        this.myConfig.ENABLE_LAUNCH_OPTIMIZATION = value;
    }

    public boolean isHideBanner() {
        return this.myConfig.HIDE_BANNER;
    }

    public void setHideBanner(boolean value) {
        this.myConfig.HIDE_BANNER = value;
    }

    public boolean isEnableJmxAgent() {
        return this.myConfig.ENABLE_JMX_AGENT;
    }

    public void setEnableJmxAgent(boolean value) {
        this.myConfig.ENABLE_JMX_AGENT = value;
    }

    @Deprecated
    public boolean isShowInDashboard() {
        return this.myConfig.SHOW_IN_DASHBOARD;
    }

    @Deprecated
    public void setShowInDashboard(boolean value) {
        this.myConfig.SHOW_IN_DASHBOARD = value;
    }

    public List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myConfig.ADDITIONAL_PARAMETERS;
    }

    public void setAdditionalParameters(List<SpringBootAdditionalParameter> values) {
        ArrayList<SpringBootAdditionalParameter> copy = new ArrayList<SpringBootAdditionalParameter>();
        for (SpringBootAdditionalParameter value : values) {
            copy.add(new SpringBootAdditionalParameter(value.isEnabled(), value.getName(), value.getValue()));
        }
        this.myConfig.ADDITIONAL_PARAMETERS = copy;
    }

    public String getActiveProfiles() {
        return this.myConfig.ACTIVE_PROFILES;
    }

    public void setActiveProfiles(String value) {
        this.myConfig.ACTIVE_PROFILES = value;
    }

    public String getUrlPath() {
        return this.myConfig.URL_PATH;
    }

    public void setUrlPath(String value) {
        this.myConfig.URL_PATH = value;
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        if (SpringBootApplicationLifecycleManager.getInstance((Project)this.getProject()).isLifecycleManagementEnabled(startedProcess) && manager instanceof LogConsoleManagerBase) {
            SpringBootApplicationRunConfiguration clone = (SpringBootApplicationRunConfiguration)this.clone();
            ((LogConsoleManagerBase)manager).addAdditionalTabComponent((AdditionalTabComponent)new SpringBootApplicationEndpointsTab(clone, startedProcess), SpringBootRunBundle.message("spring.boot.application.endpoints.tab.title", new Object[0]), SpringBootRunIcons.SpringBootEndpoint, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SpringBootApplicationRunConfigurationBean {
        public String SPRING_BOOT_MAIN_CLASS = "";
        public boolean DEBUG_MODE = false;
        public boolean ENABLE_LAUNCH_OPTIMIZATION = true;
        public boolean HIDE_BANNER = false;
        public boolean ENABLE_JMX_AGENT = true;
        @Deprecated
        public boolean SHOW_IN_DASHBOARD = false;
        public String ACTIVE_PROFILES = "";
        public String URL_PATH = "";
        public String VM_PARAMETERS = "";
        public String PROGRAM_PARAMETERS = "";
        public String WORKING_DIRECTORY = "";
        public boolean ALTERNATIVE_JRE_PATH_ENABLED;
        public String ALTERNATIVE_JRE_PATH = "";
        public boolean PASS_PARENT_ENVS = true;
        @Tag(value="additionalParameters")
        @AbstractCollection(surroundWithTag=false)
        public List<SpringBootAdditionalParameter> ADDITIONAL_PARAMETERS = new ArrayList<SpringBootAdditionalParameter>();

        private SpringBootApplicationRunConfigurationBean() {
        }
    }
}

