/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.ws.rest.client.RestClientAuthData;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RestClientRequest {
    public List<Biscuit> biscuits = new ArrayList<Biscuit>();
    public String httpMethod;
    public String urlBase;
    public String urlPath;
    public List<KeyValuePair> headers = new ArrayList<KeyValuePair>();
    public List<KeyValuePair> parameters = new ArrayList<KeyValuePair>();
    public boolean parametersEnabled;
    public boolean haveTextToSend;
    public boolean haveFileToSend;
    public boolean isFileUpload;
    public String textToSend;
    public String filesToSend;
    @Transient
    public List<RestClientFormBodyPart> formBodyPart = new ArrayList<RestClientFormBodyPart>();
    @Transient
    public String multipartBoundary = null;
    @Transient
    public RestClientAuthData authData = null;

    public String getHeaderValue(String name, String defaultValue) {
        for (KeyValuePair header : this.headers) {
            if (!name.equals(header.getKey())) continue;
            return header.getValue();
        }
        return defaultValue;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : StringUtil.split((String)this.filesToSend, (String)File.pathSeparator)) {
            files.add(new File(path));
        }
        return files;
    }

    public String getURL() {
        String base = this.urlBase;
        if (!base.endsWith("/") && this.urlPath.length() > 0) {
            base = base + "/";
        }
        base = this.urlPath.startsWith("/") ? base + this.urlPath.substring(1) : base + this.urlPath;
        return base.replace(" ", "%20");
    }

    public String createQueryString() {
        return StringUtil.join(this.parameters, pair -> {
            try {
                String key = URLEncoder.encode(pair.getKey(), "UTF-8");
                String value = URLEncoder.encode(pair.getValue(), "UTF-8");
                return key + "=" + value;
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }, (String)"&");
    }

    public String toString() {
        String url = this.getURL();
        String queryString = this.createQueryString();
        if (queryString.length() > 0) {
            return url + (url.contains("?") ? "&" : "?") + queryString;
        }
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientRequest request = (RestClientRequest)o;
        if (this.haveFileToSend != request.haveFileToSend) {
            return false;
        }
        if (this.haveTextToSend != request.haveTextToSend) {
            return false;
        }
        if (this.isFileUpload != request.isFileUpload) {
            return false;
        }
        if (this.parametersEnabled != request.parametersEnabled) {
            return false;
        }
        if (this.filesToSend != null ? !this.filesToSend.equals(request.filesToSend) : request.filesToSend != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(request.headers) : request.headers != null) {
            return false;
        }
        if (this.httpMethod != null ? !this.httpMethod.equals(request.httpMethod) : request.httpMethod != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(request.parameters) : request.parameters != null) {
            return false;
        }
        if (this.textToSend != null ? !this.textToSend.equals(request.textToSend) : request.textToSend != null) {
            return false;
        }
        if (this.urlBase != null ? !this.urlBase.equals(request.urlBase) : request.urlBase != null) {
            return false;
        }
        if (this.urlPath != null ? !this.urlPath.equals(request.urlPath) : request.urlPath != null) {
            return false;
        }
        if (this.biscuits != null ? !this.biscuits.equals(request.biscuits) : request.biscuits != null) {
            return false;
        }
        if (this.formBodyPart != null ? !this.formBodyPart.equals(request.formBodyPart) : request.formBodyPart != null) {
            return false;
        }
        if (this.multipartBoundary != null ? !this.multipartBoundary.equals(request.multipartBoundary) : request.multipartBoundary != null) {
            return false;
        }
        return !(this.authData != null ? !this.authData.equals(request.authData) : request.authData != null);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.httpMethod);
        result = 31 * result + Objects.hashCode(this.urlBase);
        result = 31 * result + Objects.hashCode(this.urlPath);
        result = 31 * result + Objects.hashCode(this.headers);
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + (this.parametersEnabled ? 1 : 0);
        result = 31 * result + (this.haveTextToSend ? 1 : 0);
        result = 31 * result + (this.haveFileToSend ? 1 : 0);
        result = 31 * result + (this.isFileUpload ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.textToSend);
        result = 31 * result + Objects.hashCode(this.filesToSend);
        result = 31 * result + Objects.hashCode(this.formBodyPart);
        result = 31 * result + Objects.hashCode(this.multipartBoundary);
        result = 31 * result + Objects.hashCode(this.authData);
        result = 31 * result + Objects.hashCode(this.biscuits);
        return result;
    }

    public static class Biscuit {
        private String myName;
        private String myValue;
        private String myDomain;
        private String myPath;
        private long myDate;

        public Biscuit() {
        }

        public Biscuit(String name, String value, String domain, String path, long date) {
            this.myName = name;
            this.myValue = value;
            this.myDomain = domain;
            this.myPath = path;
            this.myDate = date;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public String getDomain() {
            return this.myDomain;
        }

        public void setDomain(String domain) {
            this.myDomain = domain;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public long getDate() {
            return this.myDate;
        }

        public void setDate(long date) {
            this.myDate = date;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Biscuit biscuit = (Biscuit)o;
            if (this.myDate != biscuit.myDate) {
                return false;
            }
            if (this.myDomain != null ? !this.myDomain.equals(biscuit.myDomain) : biscuit.myDomain != null) {
                return false;
            }
            if (!this.myName.equals(biscuit.myName)) {
                return false;
            }
            if (this.myPath != null ? !this.myPath.equals(biscuit.myPath) : biscuit.myPath != null) {
                return false;
            }
            return this.myValue.equals(biscuit.myValue);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myValue.hashCode();
            result = 31 * result + (this.myDomain != null ? this.myDomain.hashCode() : 0);
            result = 31 * result + (this.myPath != null ? this.myPath.hashCode() : 0);
            result = 31 * result + (int)(this.myDate ^ this.myDate >>> 32);
            return result;
        }
    }

    public static class KeyValuePair {
        private String myKey;
        private String myValue;

        public KeyValuePair() {
        }

        public KeyValuePair(String key, String value) {
            this.myKey = key;
            this.myValue = value;
        }

        public String getKey() {
            return this.myKey;
        }

        public void setKey(String key) {
            this.myKey = key;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair pair = (KeyValuePair)o;
            if (!this.myKey.equals(pair.myKey)) {
                return false;
            }
            return this.myValue.equals(pair.myValue);
        }

        public int hashCode() {
            int result = this.myKey.hashCode();
            result = 31 * result + this.myValue.hashCode();
            return result;
        }
    }
}

