/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.run.HttpResponseProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpPhysicalResponseProcessor
implements HttpResponseProcessor {
    protected HttpRequest myRequest;

    public HttpPhysicalResponseProcessor(@NotNull HttpRequest request) {
        if (request == null) {
            HttpPhysicalResponseProcessor.$$$reportNull$$$0(0);
        }
        this.myRequest = request;
    }

    @Override
    public void onResponseExecuted(@Nullable String fileName) {
        PsiFile file = this.myRequest.getContainingFile();
        if (file == null) {
            return;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myRequest.getProject());
        Document document = manager.getDocument(file);
        if (document != null) {
            this.updateRequest(document, fileName);
            manager.commitDocument(document);
        }
    }

    protected void updateRequest(@NotNull Document document, @Nullable String responseFileName) {
        PsiElement nextSeparator;
        if (document == null) {
            HttpPhysicalResponseProcessor.$$$reportNull$$$0(1);
        }
        if ((nextSeparator = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)this.myRequest, HttpRequestElementTypes.REQUEST_SEPARATOR, true)) == null) {
            int endOffset = this.myRequest.getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)("\n\n" + HttpRequestPsiConverter.getSeparator()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/HttpPhysicalResponseProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

